/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.collect.ImmutableMap;
import com.indeed.proctor.common.PayloadType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Payload {
    @Nullable
    private Double doubleValue;
    @Nullable
    private Double[] doubleArray;
    @Nullable
    private Long longValue;
    @Nullable
    private Long[] longArray;
    @Nullable
    private String stringValue;
    @Nullable
    private String[] stringArray;
    @Nullable
    private Map<String, Object> map;
    public static final Payload EMPTY_PAYLOAD = new Payload();
    public static final String PAYLOAD_OVERWRITE_EXCEPTION = "Expected all properties to be empty: ";
    private static final Map<PayloadType, Function<Payload, Object>> resolvers = ImmutableMap.builder().put((Object)PayloadType.DOUBLE_VALUE, Payload::getDoubleValue).put((Object)PayloadType.DOUBLE_ARRAY, Payload::getDoubleArray).put((Object)PayloadType.LONG_VALUE, Payload::getLongValue).put((Object)PayloadType.LONG_ARRAY, Payload::getLongArray).put((Object)PayloadType.STRING_VALUE, Payload::getStringValue).put((Object)PayloadType.STRING_ARRAY, Payload::getStringArray).put((Object)PayloadType.MAP, Payload::getMap).build();

    public Payload(String value) {
        this.stringValue = value;
    }

    public Payload(Double value) {
        this.doubleValue = value;
    }

    public Payload(Long value) {
        this.longValue = value;
    }

    public Payload(Map<String, Object> value) {
        this.map = new HashMap<String, Object>(value);
    }

    public Payload(String[] values) {
        this.stringArray = Arrays.copyOf(values, values.length);
    }

    public Payload(Double[] values) {
        this.doubleArray = Arrays.copyOf(values, values.length);
    }

    public Payload(Long[] values) {
        this.longArray = Arrays.copyOf(values, values.length);
    }

    public Payload() {
    }

    public Payload(@Nonnull Payload other) {
        this.doubleValue = other.doubleValue;
        if (other.doubleArray != null) {
            this.doubleArray = Arrays.copyOf(other.doubleArray, other.doubleArray.length);
        }
        this.longValue = other.longValue;
        if (other.longArray != null) {
            this.longArray = Arrays.copyOf(other.longArray, other.longArray.length);
        }
        this.stringValue = other.stringValue;
        if (other.stringArray != null) {
            this.stringArray = Arrays.copyOf(other.stringArray, other.stringArray.length);
        }
        if (other.map != null) {
            this.map = new HashMap<String, Object>(other.map);
        }
    }

    @Nullable
    public Double getDoubleValue() {
        return this.doubleValue;
    }

    public void setDoubleValue(@Nullable Double doubleValue) {
        this.precheckStateAllNull();
        this.doubleValue = doubleValue;
    }

    @Nullable
    public Double[] getDoubleArray() {
        return this.doubleArray;
    }

    public void setDoubleArray(@Nullable Double[] doubleArray) {
        this.precheckStateAllNull();
        this.doubleArray = doubleArray;
    }

    @Nullable
    public Long getLongValue() {
        return this.longValue;
    }

    public void setLongValue(@Nullable Long longValue) {
        this.precheckStateAllNull();
        this.longValue = longValue;
    }

    @Nullable
    public Long[] getLongArray() {
        return this.longArray;
    }

    public void setLongArray(@Nullable Long[] longArray) {
        this.precheckStateAllNull();
        this.longArray = longArray;
    }

    @Nullable
    public String getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(@Nullable String stringValue) {
        this.precheckStateAllNull();
        this.stringValue = stringValue;
    }

    @Nullable
    public String[] getStringArray() {
        return this.stringArray;
    }

    public void setStringArray(@Nullable String[] stringArray) {
        this.precheckStateAllNull();
        this.stringArray = stringArray;
    }

    @Nullable
    public Map<String, Object> getMap() {
        return this.map;
    }

    public void setMap(@Nullable Map<String, Object> map) {
        this.precheckStateAllNull();
        this.map = map;
    }

    private void precheckStateAllNull() throws IllegalStateException {
        if (this.doubleValue != null || this.doubleArray != null || this.longValue != null || this.longArray != null || this.stringValue != null || this.stringArray != null || this.map != null) {
            throw new IllegalStateException(PAYLOAD_OVERWRITE_EXCEPTION + this);
        }
    }

    @Nonnull
    public String toString() {
        StringBuilder s = new StringBuilder(50).append('{');
        if (this.map != null) {
            s.append(" map : [");
            for (Map.Entry<String, Object> entry : this.map.entrySet()) {
                s.append('(').append(entry.getKey()).append(',').append(entry.getValue()).append(')');
            }
            s.append(']');
        }
        if (this.doubleValue != null) {
            s.append(" doubleValue : ").append(this.doubleValue);
        }
        if (this.doubleArray != null) {
            s.append(" doubleArray : [");
            s.append(StringUtils.join((Object[])this.doubleArray, (String)", "));
            s.append(']');
        }
        if (this.longValue != null) {
            s.append(" longValue : ").append(this.longValue);
        }
        if (this.longArray != null) {
            s.append(" longArray : [");
            s.append(StringUtils.join((Object[])this.longArray, (String)", "));
            s.append(']');
        }
        if (this.stringValue != null) {
            s.append(" stringValue : \"").append(this.stringValue).append('\"');
        }
        if (this.stringArray != null) {
            s.append(" stringArray : [");
            if (this.stringArray.length > 0) {
                s.append('\"');
                s.append(String.join((CharSequence)"\", \"", this.stringArray));
                s.append('\"');
            }
            s.append(']');
        }
        s.append(" }");
        return s.toString();
    }

    @Nonnull
    public Optional<PayloadType> fetchPayloadType() {
        return Optional.ofNullable(this.getPayloadType());
    }

    public static boolean hasType(Payload payload, PayloadType payloadType) {
        if (payload == null) {
            return false;
        }
        Function<Payload, Object> resolver = resolvers.get((Object)payloadType);
        return resolver != null && resolver.apply(payload) != null;
    }

    @CheckForNull
    private PayloadType getPayloadType() {
        return Stream.of(PayloadType.values()).filter(pt -> resolvers.get(pt).apply(this) != null).findFirst().orElse(null);
    }

    @Nonnull
    @Deprecated
    public String fetchType() {
        return this.fetchPayloadType().map(t -> t.payloadTypeName).orElse("none");
    }

    public boolean sameType(@Nullable Payload other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return this.getPayloadType() == other.getPayloadType();
    }

    public int numFieldsDefined() {
        return (int)Stream.of(PayloadType.values()).filter(pt -> resolvers.get(pt).apply(this) != null).count();
    }

    @CheckForNull
    public Object fetchAValue() {
        return Stream.of(PayloadType.values()).map(pt -> resolvers.get(pt).apply(this)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Payload payload = (Payload)o;
        return Objects.equals(this.doubleValue, payload.doubleValue) && Arrays.equals((Object[])this.doubleArray, (Object[])payload.doubleArray) && Objects.equals(this.longValue, payload.longValue) && Arrays.equals((Object[])this.longArray, (Object[])payload.longArray) && Objects.equals(this.stringValue, payload.stringValue) && Arrays.equals(this.stringArray, payload.stringArray) && Objects.equals(this.map, payload.map);
    }

    public int hashCode() {
        int result = Objects.hash(this.doubleValue, this.longValue, this.stringValue, this.map);
        result = 31 * result + Arrays.hashCode((Object[])this.doubleArray);
        result = 31 * result + Arrays.hashCode((Object[])this.longArray);
        result = 31 * result + Arrays.hashCode(this.stringArray);
        return result;
    }
}

