/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.indeed.proctor.common.AbstractJsonProctorLoader;
import com.indeed.proctor.common.AbstractProctorDiffReporter;
import com.indeed.proctor.common.ClasspathProctorLoader;
import com.indeed.proctor.common.FileProctorLoader;
import com.indeed.proctor.common.ProctorLoadReporter;
import com.indeed.proctor.common.ProctorSpecification;
import com.indeed.proctor.common.RuleEvaluator;
import com.indeed.proctor.common.Serializers;
import com.indeed.shaded.javax.el7.FunctionMapper;
import com.indeed.util.varexport.ManagedVariable;
import com.indeed.util.varexport.VarExporter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class JsonProctorLoaderFactory {
    private static final Logger LOGGER = Logger.getLogger(JsonProctorLoaderFactory.class);
    private static final ObjectMapper OBJECT_MAPPER = Serializers.lenient();
    private static final String EXPORT_NAME_PREFIX_FOR_SPECIFICATION = "specification";
    protected static final VarExporter VAR_EXPORTER = VarExporter.forNamespace((String)JsonProctorLoaderFactory.class.getSimpleName());
    @Nullable
    protected String classResourcePath;
    @Nullable
    protected String filePath;
    @Nullable
    protected ProctorSpecification _specification;
    protected FunctionMapper functionMapper = RuleEvaluator.FUNCTION_MAPPER;
    protected List<ProctorLoadReporter> reporters = new ArrayList<ProctorLoadReporter>();

    public void setClassResourcePath(@Nullable String classResourcePath) {
        this.classResourcePath = classResourcePath;
    }

    public void setFilePath(@Nullable String filePath) {
        this.filePath = filePath;
    }

    public void setSpecificationResource(@Nonnull Resource specificationResource) {
        try (InputStream stream = specificationResource.getInputStream();){
            this._specification = (ProctorSpecification)OBJECT_MAPPER.readValue(stream, ProctorSpecification.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to read proctor specification from " + specificationResource, e);
        }
        this.exportJsonSpecification(JsonProctorLoaderFactory.generateExportVariableNameFromResource(specificationResource), this._specification);
    }

    public void setSpecificationResource(@Nonnull String specificationLocation) {
        if (specificationLocation.startsWith("classpath:")) {
            String specificationClasspath = specificationLocation.replace("classpath:", "");
            this.setSpecificationResource((Resource)new ClassPathResource(specificationClasspath, this.getClass()));
        } else {
            this.setSpecificationResource((Resource)new FileSystemResource(specificationLocation));
        }
    }

    public void setSpecification(@Nonnull ProctorSpecification specification) {
        this._specification = Objects.requireNonNull(specification, "Null specifications are not supported");
        this.exportJsonSpecification(JsonProctorLoaderFactory.generateExportVariableNameFromObject(specification), specification);
    }

    public void setFunctionMapper(@Nonnull FunctionMapper functionMapper) {
        this.functionMapper = functionMapper;
    }

    @Nonnull
    public AbstractJsonProctorLoader getLoader() {
        if (this.classResourcePath == null == (this.filePath == null)) {
            throw new IllegalStateException("Must have exactly one of classResourcePath or filePath");
        }
        ProctorSpecification specification = (ProctorSpecification)Preconditions.checkNotNull((Object)this._specification, (Object)"Missing specification");
        if (this.classResourcePath != null) {
            return new ClasspathProctorLoader(specification, this.classResourcePath, this.functionMapper);
        }
        FileProctorLoader loader = new FileProctorLoader(specification, this.filePath, this.functionMapper);
        loader.addLoadReporter(this.reporters);
        return loader;
    }

    @Deprecated
    public void setDiffReporter(AbstractProctorDiffReporter diffReporter) {
        Preconditions.checkNotNull((Object)diffReporter, (Object)"diff reporter can't be null use AbstractProctorDiffReporter for nop implementation");
        this.setLoadReporters((List<ProctorLoadReporter>)ImmutableList.of((Object)diffReporter));
    }

    public void setLoadReporters(List<ProctorLoadReporter> reporters) {
        this.reporters = reporters;
    }

    private void exportJsonSpecification(String variableName, ProctorSpecification specification) {
        try {
            ManagedVariable managedVariable = ManagedVariable.builder().setName(variableName).setValue((Object)OBJECT_MAPPER.writeValueAsString((Object)specification)).build();
            VAR_EXPORTER.export(managedVariable);
        }
        catch (JsonProcessingException e) {
            LOGGER.warn((Object)"Failed to expose json specification in VarExporter.", (Throwable)e);
        }
    }

    private static String generateExportVariableNameFromResource(Resource resource) {
        return "specification-" + resource.getFilename();
    }

    private static String generateExportVariableNameFromObject(ProctorSpecification specification) {
        return "specification-anonymous-" + Integer.toHexString(specification.hashCode());
    }
}

