/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common;

import com.indeed.proctor.common.model.Payload;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum PayloadType {
    DOUBLE_VALUE("doubleValue", "Double", "number", "-1", "getDoubleValue", false),
    DOUBLE_ARRAY("doubleArray", "Double[]", "Array.<number>", "[]", "getDoubleArray", true),
    LONG_VALUE("longValue", "Long", "number", "-1", "getLongValue", false),
    LONG_ARRAY("longArray", "Long[]", "Array.<number>", "[]", "getLongArray", true),
    STRING_VALUE("stringValue", "String", "string", "''", "getStringValue", false),
    STRING_ARRAY("stringArray", "String[]", "Array.<string>", "[]", "getStringArray", true),
    MAP("map", "Map<String,Object>", "Object.<string, Object>", "{}", "getMap", false);

    @Nonnull
    public final String payloadTypeName;
    @Nonnull
    public final String javaClassName;
    @Nonnull
    public final String javascriptTypeName;
    @Nonnull
    private final String javascriptDefaultValue;
    @Nonnull
    public final String javaAccessorName;
    private final boolean isArraysType;

    private PayloadType(@Nonnull String payloadTypeName, @Nonnull String javaClassName, @Nonnull String javascriptTypeName, String javascriptDefaultValue, String javaAccessorName, boolean isArraysType) {
        this.payloadTypeName = payloadTypeName;
        this.javaClassName = javaClassName;
        this.javascriptTypeName = javascriptTypeName;
        this.javascriptDefaultValue = javascriptDefaultValue;
        this.javaAccessorName = javaAccessorName;
        this.isArraysType = isArraysType;
    }

    @Deprecated
    public boolean payloadHasThisType(@Nullable Payload payload) {
        return Payload.hasType(payload, this);
    }

    public String getDefaultJavascriptValue() {
        return this.javascriptDefaultValue;
    }

    @Nonnull
    public static PayloadType payloadTypeForName(@Nonnull String payloadTypeName) throws IllegalArgumentException {
        for (PayloadType p : PayloadType.values()) {
            if (!payloadTypeName.equals(p.payloadTypeName)) continue;
            return p;
        }
        throw new IllegalArgumentException("Payload type name " + payloadTypeName + " is not in the list of standard values: " + PayloadType.allTypeNames().toString());
    }

    @Nonnull
    public static PayloadType payloadTypeForValue(@Nullable Object payloadValue) throws IllegalArgumentException {
        if (payloadValue == null) {
            throw new IllegalArgumentException("Cannot infer payload type for null value");
        }
        if (payloadValue instanceof List) {
            HashSet<PayloadType> types = new HashSet<PayloadType>();
            for (Object value : (List)payloadValue) {
                types.add(PayloadType.payloadTypeForValue(value));
            }
            if (types.size() == 2 && types.contains((Object)LONG_VALUE) && types.contains((Object)DOUBLE_VALUE)) {
                types.remove((Object)LONG_VALUE);
            }
            if (types.size() != 1) {
                throw new IllegalArgumentException("Cannot infer payload type for list " + payloadValue);
            }
            switch ((PayloadType)((Object)types.iterator().next())) {
                case LONG_VALUE: {
                    return LONG_ARRAY;
                }
                case DOUBLE_VALUE: {
                    return DOUBLE_ARRAY;
                }
                case STRING_VALUE: {
                    return STRING_ARRAY;
                }
            }
            throw new IllegalArgumentException("Unsupported type returned for List content " + types);
        }
        if (payloadValue instanceof String[]) {
            return STRING_ARRAY;
        }
        if (payloadValue instanceof Long[] || payloadValue instanceof Integer[]) {
            return LONG_ARRAY;
        }
        if (payloadValue instanceof Double[] || payloadValue instanceof Float[]) {
            return DOUBLE_ARRAY;
        }
        if (payloadValue instanceof Map) {
            return MAP;
        }
        return PayloadType.payloadTypeForPrimitiveValue(payloadValue);
    }

    private static PayloadType payloadTypeForPrimitiveValue(@Nonnull Object payloadValue) {
        if (payloadValue instanceof Long || payloadValue instanceof Integer) {
            return LONG_VALUE;
        }
        if (payloadValue instanceof Double || payloadValue instanceof Float) {
            return DOUBLE_VALUE;
        }
        if (payloadValue instanceof String) {
            return STRING_VALUE;
        }
        throw new IllegalArgumentException("Payload value " + payloadValue.getClass().getSimpleName() + " : " + payloadValue + " does not correspond to a payload type");
    }

    @Nonnull
    public static List<String> allTypeNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (PayloadType p : PayloadType.values()) {
            names.add(p.payloadTypeName);
        }
        return names;
    }

    public boolean isArrayType() {
        return this.isArraysType;
    }
}

