/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import com.indeed.proctor.common.Identifiers;
import com.indeed.proctor.common.ProctorLoadResult;
import com.indeed.proctor.common.ProctorResult;
import com.indeed.proctor.common.RandomTestChooser;
import com.indeed.proctor.common.RuleEvaluator;
import com.indeed.proctor.common.Serializers;
import com.indeed.proctor.common.StandardTestChooser;
import com.indeed.proctor.common.TestChooser;
import com.indeed.proctor.common.model.Allocation;
import com.indeed.proctor.common.model.Audit;
import com.indeed.proctor.common.model.ConsumableTestDefinition;
import com.indeed.proctor.common.model.TestBucket;
import com.indeed.proctor.common.model.TestMatrixArtifact;
import com.indeed.proctor.common.model.TestType;
import com.indeed.shaded.javax.el7.ExpressionFactory;
import com.indeed.shaded.javax.el7.FunctionMapper;
import com.indeed.util.varexport.VarExporter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nonnull;

public class Proctor {
    public static final Proctor EMPTY = Proctor.createEmptyProctor();
    private static final ObjectWriter OBJECT_WRITER = Serializers.lenient().configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false).writerWithDefaultPrettyPrinter();
    static final long INT_RANGE = 0xFFFFFFFFL;
    private final TestMatrixArtifact matrix;
    private final ProctorLoadResult loadResult;
    @Nonnull
    private final Map<String, TestChooser<?>> testChoosers;
    private final Map<String, ConsumableTestDefinition> testDefinitions = Maps.newLinkedHashMap();

    @Nonnull
    public static Proctor construct(@Nonnull TestMatrixArtifact matrix, @Nonnull ProctorLoadResult loadResult, @Nonnull FunctionMapper functionMapper) {
        ExpressionFactory expressionFactory = RuleEvaluator.EXPRESSION_FACTORY;
        LinkedHashMap testChoosers = Maps.newLinkedHashMap();
        LinkedHashMap versions = Maps.newLinkedHashMap();
        for (Map.Entry<String, ConsumableTestDefinition> entry : matrix.getTests().entrySet()) {
            String testName = entry.getKey();
            ConsumableTestDefinition testDefinition = entry.getValue();
            TestType testType = testDefinition.getTestType();
            TestChooser<Void> testChooser = TestType.RANDOM.equals(testType) ? new RandomTestChooser(expressionFactory, functionMapper, testName, testDefinition) : new StandardTestChooser(expressionFactory, functionMapper, testName, testDefinition);
            testChoosers.put(testName, testChooser);
            versions.put(testName, testDefinition.getVersion());
        }
        return new Proctor(matrix, loadResult, testChoosers);
    }

    @Nonnull
    @VisibleForTesting
    static Proctor createEmptyProctor() {
        Audit audit = new Audit();
        audit.setUpdated(0L);
        audit.setUpdatedBy("nobody");
        audit.setVersion("");
        TestMatrixArtifact testMatrix = new TestMatrixArtifact();
        testMatrix.setAudit(audit);
        ProctorLoadResult loadResult = ProctorLoadResult.emptyResult();
        Map<String, TestChooser<?>> choosers = Collections.emptyMap();
        return new Proctor(testMatrix, loadResult, choosers);
    }

    @VisibleForTesting
    Proctor(@Nonnull TestMatrixArtifact matrix, @Nonnull ProctorLoadResult loadResult, @Nonnull Map<String, TestChooser<?>> testChoosers) {
        this.matrix = matrix;
        this.loadResult = loadResult;
        this.testChoosers = testChoosers;
        for (Map.Entry<String, TestChooser<?>> entry : testChoosers.entrySet()) {
            this.testDefinitions.put(entry.getKey(), entry.getValue().getTestDefinition());
        }
        VarExporter.forNamespace((String)Proctor.class.getSimpleName()).includeInGlobal().export((Object)this, "");
        VarExporter.forNamespace((String)DetailedExport.class.getSimpleName()).export((Object)new DetailedExport(), "");
    }

    @Nonnull
    public ProctorResult determineTestGroups(TestType testType, String identifier, @Nonnull Map<String, Object> context, @Nonnull Map<String, Integer> forceGroups) {
        Identifiers identifiers = new Identifiers(testType, identifier);
        return this.determineTestGroups(identifiers, context, forceGroups);
    }

    @Nonnull
    public ProctorResult determineTestGroups(@Nonnull Identifiers identifiers, @Nonnull Map<String, Object> inputContext, @Nonnull Map<String, Integer> forceGroups) {
        return this.determineTestGroups(identifiers, inputContext, forceGroups, Collections.emptyList());
    }

    @Nonnull
    public ProctorResult determineTestGroups(@Nonnull Identifiers identifiers, @Nonnull Map<String, Object> inputContext, @Nonnull Map<String, Integer> forceGroups, @Nonnull Collection<String> testNameFilter) {
        Map<Object, Object> filteredChoosers;
        TreeMap<String, TestBucket> testGroups = new TreeMap<String, TestBucket>();
        TreeMap<String, Allocation> testAllocations = new TreeMap<String, Allocation>();
        if (testNameFilter.isEmpty()) {
            filteredChoosers = this.testChoosers;
        } else {
            filteredChoosers = Maps.newLinkedHashMap();
            for (String string : testNameFilter) {
                if (!this.testChoosers.containsKey(string)) continue;
                filteredChoosers.put(string, this.testChoosers.get(string));
            }
        }
        for (Map.Entry entry : filteredChoosers.entrySet()) {
            TestBucket forcedTestBucket;
            String identifier;
            String testName = (String)entry.getKey();
            Integer forceGroupBucket = forceGroups.get(testName);
            TestChooser testChooser = (TestChooser)entry.getValue();
            if (testChooser instanceof StandardTestChooser) {
                TestType testType = testChooser.getTestDefinition().getTestType();
                identifier = identifiers.getIdentifier(testType);
                if (identifier == null) {
                    continue;
                }
            } else {
                if (!identifiers.isRandomEnabled()) continue;
                identifier = null;
            }
            if (forceGroupBucket != null && (forcedTestBucket = testChooser.getTestBucket(forceGroupBucket)) != null) {
                testGroups.put(testName, forcedTestBucket);
                continue;
            }
            TestChooser.Result chooseResult = identifier == null ? ((RandomTestChooser)testChooser).choose(null, inputContext) : ((StandardTestChooser)testChooser).choose(identifier, inputContext);
            if (chooseResult.getTestBucket() != null) {
                testGroups.put(testName, chooseResult.getTestBucket());
            }
            if (chooseResult.getAllocation() == null) continue;
            testAllocations.put(testName, chooseResult.getAllocation());
        }
        Audit audit = (Audit)Preconditions.checkNotNull((Object)this.matrix.getAudit(), (Object)"Missing audit");
        return new ProctorResult(audit.getVersion(), (SortedMap<String, TestBucket>)testGroups, (SortedMap<String, Allocation>)testAllocations, this.testDefinitions);
    }

    TestMatrixArtifact getArtifact() {
        return this.matrix;
    }

    public Set<String> getTestNames() {
        return Collections.unmodifiableSet(this.matrix.getTests().keySet());
    }

    public ConsumableTestDefinition getTestDefinition(String name) {
        return this.matrix.getTests().get(name);
    }

    public ProctorLoadResult getLoadResult() {
        return this.loadResult;
    }

    public void appendAllTests(Writer sb) {
        this.appendTests(sb, Predicates.alwaysTrue());
    }

    public void appendTests(Writer sb, final TestType type) {
        this.appendTests(sb, new Predicate<TestChooser<?>>(){

            public boolean apply(TestChooser<?> input) {
                assert (null != input);
                return type == input.getTestDefinition().getTestType();
            }
        });
    }

    public void appendTestsNameFiltered(Writer sb, Collection<String> testNameFilter) {
        Function getTestName = new Function<TestChooser<?>, String>(){

            public String apply(TestChooser<?> input) {
                return input.getTestName();
            }
        };
        this.appendTests(sb, Predicates.compose((Predicate)Predicates.in(testNameFilter), (Function)getTestName));
    }

    public void appendTests(Writer sb, @Nonnull Predicate<TestChooser<?>> shouldIncludeTest) {
        PrintWriter writer = new PrintWriter(sb);
        for (Map.Entry<String, TestChooser<?>> entry : this.testChoosers.entrySet()) {
            String testName = entry.getKey();
            TestChooser<?> chooser = entry.getValue();
            if (!shouldIncludeTest.apply(chooser)) continue;
            writer.append(testName).append(" : ");
            chooser.printTestBuckets(writer);
            writer.println();
        }
    }

    public void appendTestMatrix(Writer writer) throws IOException {
        OBJECT_WRITER.writeValue(writer, (Object)this.matrix);
    }

    public void appendTestMatrixFiltered(Writer writer, Collection<String> testNameFilter) throws IOException {
        TestMatrixArtifact filtered = new TestMatrixArtifact();
        filtered.setAudit(this.matrix.getAudit());
        filtered.setTests(Maps.filterKeys(this.matrix.getTests(), (Predicate)Predicates.in(testNameFilter)));
        OBJECT_WRITER.writeValue(writer, (Object)filtered);
    }

    private static class DetailedExport {
        private DetailedExport() {
        }
    }
}

