/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common;

import com.google.common.collect.Maps;
import com.indeed.proctor.common.model.Allocation;
import com.indeed.proctor.common.model.ConsumableTestDefinition;
import com.indeed.proctor.common.model.TestBucket;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ProctorResult {
    public static final ProctorResult EMPTY = new ProctorResult("", Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
    private final String matrixVersion;
    @Nonnull
    private final SortedMap<String, TestBucket> buckets;
    @Nonnull
    private final SortedMap<String, Allocation> allocations;
    @Nonnull
    private final Map<String, ConsumableTestDefinition> testDefinitions;

    @Deprecated
    public ProctorResult(int matrixVersion, @Nonnull Map<String, TestBucket> buckets, @Nullable Map<String, ConsumableTestDefinition> testDefinitions) {
        this(Integer.toString(matrixVersion), buckets, Collections.emptyMap(), testDefinitions);
    }

    @Deprecated
    public ProctorResult(String matrixVersion, @Nonnull Map<String, TestBucket> buckets, @Nullable Map<String, ConsumableTestDefinition> testDefinitions) {
        this(matrixVersion, buckets, Collections.emptyMap(), testDefinitions);
    }

    public ProctorResult(String matrixVersion, @Nonnull Map<String, TestBucket> buckets, @Nonnull Map<String, Allocation> allocations, @Nullable Map<String, ConsumableTestDefinition> testDefinitions) {
        this.matrixVersion = matrixVersion;
        this.buckets = new TreeMap<String, TestBucket>(buckets);
        this.allocations = new TreeMap<String, Allocation>(allocations);
        this.testDefinitions = testDefinitions == null ? Collections.emptyMap() : new HashMap<String, ConsumableTestDefinition>(testDefinitions);
    }

    public String getMatrixVersion() {
        return this.matrixVersion;
    }

    @Nonnull
    public SortedMap<String, TestBucket> getBuckets() {
        return this.buckets;
    }

    @Nonnull
    public SortedMap<String, Allocation> getAllocations() {
        return this.allocations;
    }

    @Nonnull
    public Map<String, ConsumableTestDefinition> getTestDefinitions() {
        return this.testDefinitions;
    }

    @Nonnull
    public Map<String, String> getTestVersions() {
        HashMap testVersions = Maps.newHashMapWithExpectedSize((int)this.testDefinitions.size());
        for (Map.Entry<String, ConsumableTestDefinition> entry : this.testDefinitions.entrySet()) {
            testVersions.put(entry.getKey(), entry.getValue().getVersion());
        }
        return testVersions;
    }
}

