/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.indeed.proctor.common.IncompatibleTestMatrixException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class ProctorLoadResult {
    @Nonnull
    private final Map<String, IncompatibleTestMatrixException> testErrorMap;
    @Nonnull
    private final Set<String> missingTests;
    @Nonnull
    private final Map<String, IncompatibleTestMatrixException> dynamicTestErrorMap;
    private final boolean verifiedRules;
    private static final ProctorLoadResult EMPTY = ProctorLoadResult.newBuilder().build();

    public ProctorLoadResult(@Nonnull Set<String> testsWithErrors, @Nonnull Set<String> missingTests) {
        this(testsWithErrors, missingTests, false);
    }

    public ProctorLoadResult(@Nonnull Set<String> testsWithErrors, @Nonnull Set<String> missingTests, boolean verifiedRules) {
        this(ProctorLoadResult.makeTestErrorMap(testsWithErrors), missingTests, verifiedRules);
    }

    public ProctorLoadResult(@Nonnull Map<String, IncompatibleTestMatrixException> testErrorMap, @Nonnull Set<String> missingTests, boolean verifiedRules) {
        this(testErrorMap, Collections.emptyMap(), missingTests, verifiedRules);
    }

    public ProctorLoadResult(@Nonnull Map<String, IncompatibleTestMatrixException> testErrorMap, @Nonnull Map<String, IncompatibleTestMatrixException> dynamicTestErrorMap, @Nonnull Set<String> missingTests, boolean verifiedRules) {
        this.testErrorMap = testErrorMap;
        this.dynamicTestErrorMap = dynamicTestErrorMap;
        this.missingTests = missingTests;
        this.verifiedRules = verifiedRules;
    }

    @Nonnull
    public Set<String> getTestsWithErrors() {
        return this.testErrorMap.keySet();
    }

    @Nonnull
    public Set<String> getDynamicTestWithErrors() {
        return this.dynamicTestErrorMap.keySet();
    }

    @Nonnull
    public Map<String, IncompatibleTestMatrixException> getTestErrorMap() {
        return this.testErrorMap;
    }

    @Nonnull
    public Set<String> getMissingTests() {
        return this.missingTests;
    }

    public boolean getVerifiedRules() {
        return this.verifiedRules;
    }

    private static Map<String, IncompatibleTestMatrixException> makeTestErrorMap(Set<String> testsWithErrors) {
        return Maps.asMap(testsWithErrors, (Function)new Function<String, IncompatibleTestMatrixException>(){

            public IncompatibleTestMatrixException apply(String testName) {
                return new IncompatibleTestMatrixException(testName + " has an invalid specification");
            }
        });
    }

    public boolean hasInvalidTests() {
        return !this.testErrorMap.isEmpty() || !this.missingTests.isEmpty();
    }

    @Nonnull
    public static ProctorLoadResult emptyResult() {
        return EMPTY;
    }

    @Nonnull
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private ImmutableMap.Builder<String, IncompatibleTestMatrixException> testsWithErrors = ImmutableMap.builder();
        private ImmutableMap.Builder<String, IncompatibleTestMatrixException> dynamicTestsWithErrors = ImmutableMap.builder();
        private ImmutableSet.Builder<String> missingTests = ImmutableSet.builder();
        private boolean verifiedRules = false;

        private Builder() {
        }

        @Nonnull
        public Builder recordError(String testName, IncompatibleTestMatrixException exception) {
            this.testsWithErrors.put((Object)testName, (Object)exception);
            return this;
        }

        @Nonnull
        public Builder recordIncompatibleDynamicTest(String testName, IncompatibleTestMatrixException exception) {
            this.dynamicTestsWithErrors.put((Object)testName, (Object)exception);
            return this;
        }

        @Nonnull
        public Builder recordError(String testName) {
            this.testsWithErrors.put((Object)testName, (Object)new IncompatibleTestMatrixException(testName + " has an invalid specification"));
            return this;
        }

        @Nonnull
        public Builder recordMissing(String testName) {
            this.missingTests.add((Object)testName);
            return this;
        }

        @Nonnull
        public Builder recordAllMissing(Collection<String> testNames) {
            this.missingTests.addAll(testNames);
            return this;
        }

        public Builder recordVerifiedRules(boolean verifiedRulesInput) {
            this.verifiedRules = verifiedRulesInput;
            return this;
        }

        @Nonnull
        public ProctorLoadResult build() {
            return new ProctorLoadResult((Map<String, IncompatibleTestMatrixException>)this.testsWithErrors.build(), (Map<String, IncompatibleTestMatrixException>)this.dynamicTestsWithErrors.build(), (Set<String>)this.missingTests.build(), this.verifiedRules);
        }
    }
}

