/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common;

import com.google.common.collect.Lists;
import com.indeed.proctor.common.InvalidRuleException;
import com.indeed.proctor.common.ProctorUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import org.apache.el.lang.ExpressionBuilder;
import org.apache.el.parser.AstIdentifier;
import org.apache.el.parser.Node;
import org.apache.el.parser.NodeVisitor;
import org.apache.log4j.Logger;

public class RuleVerifyUtils {
    private static final Logger LOGGER = Logger.getLogger(RuleVerifyUtils.class);

    private RuleVerifyUtils() {
    }

    public static void verifyRule(String testRule, boolean shouldEvaluate, ExpressionFactory expressionFactory, ELContext elContext, Set<String> absentIdentifiers) throws InvalidRuleException {
        String bareRule = ProctorUtils.removeElExpressionBraces(testRule);
        if (!ProctorUtils.isEmptyWhitespace(bareRule)) {
            ValueExpression valueExpression;
            try {
                valueExpression = expressionFactory.createValueExpression(elContext, testRule, Boolean.class);
            }
            catch (ELException e) {
                throw new InvalidRuleException(e, String.format("Rule %s has invalid syntax.", testRule));
            }
            RuleVerifyUtils.assertNoAssignmentsInRule(testRule);
            if (shouldEvaluate) {
                Node root;
                try {
                    root = ExpressionBuilder.createNode((String)testRule);
                }
                catch (ELException e) {
                    throw new InvalidRuleException(e, String.format("Rule %s has invalid syntax.", testRule));
                }
                Node undefinedIdentifier = RuleVerifyUtils.checkUndefinedIdentifier(root, elContext, absentIdentifiers);
                if (undefinedIdentifier != null) {
                    throw new InvalidRuleException(String.format("Rule %s contains undefined identifier : %s", testRule, undefinedIdentifier.getImage()));
                }
                try {
                    valueExpression.getValue(elContext);
                }
                catch (ELException e) {
                    if (RuleVerifyUtils.isIgnorable(root, absentIdentifiers)) {
                        LOGGER.debug((Object)String.format("Rule %s contains uninstantiated identifier(s) in %s, ignore the failure", testRule, absentIdentifiers), (Throwable)e);
                    }
                    throw new InvalidRuleException(e, String.format("Failed to evaluate a rule %s: " + e.getMessage(), testRule));
                }
            }
        }
    }

    private static void assertNoAssignmentsInRule(final String testRule) throws InvalidRuleException {
        Node rootNode = ExpressionBuilder.createNode((String)testRule);
        try {
            rootNode.accept(new NodeVisitor(){

                public void visit(Node node) throws InvalidRuleException {
                    if ("Assign".equalsIgnoreCase(node.toString())) {
                        throw new InvalidRuleException(String.format("Rule %s has invalid syntax: be sure to use '==' for comparisons.", testRule));
                    }
                    if ("Concatenation".equalsIgnoreCase(node.toString())) {
                        throw new InvalidRuleException(String.format("Rule %s has invalid syntax: do not use '+='.", testRule));
                    }
                    if ("Arrow".equalsIgnoreCase(node.toString())) {
                        throw new InvalidRuleException(String.format("Rule %s has invalid syntax: do not use '->'.", testRule));
                    }
                    if ("ListData".equalsIgnoreCase(node.toString())) {
                        throw new InvalidRuleException(String.format("Rule %s has invalid syntax: do not use [] Lists.", testRule));
                    }
                    if ("MapData".equalsIgnoreCase(node.toString())) {
                        throw new InvalidRuleException(String.format("Rule %s has invalid syntax: do not use {:} Maps.", testRule));
                    }
                    if ("SetData".equalsIgnoreCase(node.toString())) {
                        throw new InvalidRuleException(String.format("Rule %s has invalid syntax: do not use {} Sets.", testRule));
                    }
                    if ("Semicolon".equalsIgnoreCase(node.toString())) {
                        throw new InvalidRuleException(String.format("Rule %s has invalid syntax: do not use Semicolon.", testRule));
                    }
                    if (node.getClass().getName().contains("AstLambda")) {
                        throw new InvalidRuleException(String.format("Rule %s has invalid syntax: do not use -> Lambdas.", testRule));
                    }
                }
            });
        }
        catch (InvalidRuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected Exception", e);
        }
    }

    private static boolean isIgnorable(Node node, Set<String> absentIdentifiers) {
        List<Node> leaves = RuleVerifyUtils.getLeafNodes(node);
        for (Node n : leaves) {
            String image = n.getImage();
            if (!absentIdentifiers.contains(image)) continue;
            return true;
        }
        return false;
    }

    private static Node checkUndefinedIdentifier(Node node, ELContext elContext, Set<String> absentIdentifiers) {
        if (node instanceof AstIdentifier) {
            boolean hasVariable;
            String name = node.getImage();
            boolean bl = hasVariable = elContext.getVariableMapper().resolveVariable(name) != null;
            if (!hasVariable && !absentIdentifiers.contains(name)) {
                return node;
            }
        } else {
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                Node result = RuleVerifyUtils.checkUndefinedIdentifier(node.jjtGetChild(i), elContext, absentIdentifiers);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    private static List<Node> getLeafNodes(Node node) {
        ArrayList nodes = Lists.newArrayList();
        RuleVerifyUtils.find(node, nodes);
        return nodes;
    }

    private static void find(Node node, List<Node> res) {
        if (node.jjtGetNumChildren() > 0) {
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                RuleVerifyUtils.find(node.jjtGetChild(i), res);
            }
        } else {
            res.add(node);
        }
    }
}

