/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common.model;

import com.google.common.base.Strings;
import com.indeed.proctor.common.model.Range;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Allocation {
    @Nullable
    private String rule;
    @Nonnull
    private List<Range> ranges = Collections.emptyList();
    @Nonnull
    private String id = "";

    public Allocation() {
    }

    public Allocation(@Nullable String rule, @Nonnull List<Range> ranges) {
        this(rule, ranges, "");
    }

    public Allocation(@Nullable String rule, @Nonnull List<Range> ranges, @Nullable String id) {
        this.rule = rule;
        this.ranges = ranges;
        this.id = Strings.nullToEmpty((String)id);
    }

    public Allocation(@Nonnull Allocation other) {
        this.rule = other.rule;
        this.ranges = new ArrayList<Range>();
        for (Range range : other.getRanges()) {
            this.ranges.add(new Range(range));
        }
        this.id = other.id;
    }

    @Nullable
    public String getRule() {
        return this.rule;
    }

    public void setRule(@Nullable String rule) {
        this.rule = rule;
    }

    @Nonnull
    public List<Range> getRanges() {
        return this.ranges;
    }

    public void setRanges(@Nonnull List<Range> ranges) {
        this.ranges = ranges;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    public void setId(@Nullable String id) {
        this.id = Strings.nullToEmpty((String)id);
    }
}

