/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common;

import com.google.common.collect.Maps;
import com.indeed.proctor.common.InvalidRuleException;
import com.indeed.proctor.common.RandomTestChooser;
import com.indeed.proctor.common.RuleEvaluator;
import com.indeed.proctor.common.model.Allocation;
import com.indeed.proctor.common.model.ConsumableTestDefinition;
import com.indeed.proctor.common.model.Range;
import com.indeed.proctor.common.model.TestBucket;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.el.ExpressionFactory;
import javax.el.FunctionMapper;
import org.apache.log4j.Logger;

public class TestRangeSelector {
    private static final Logger LOGGER = Logger.getLogger(RandomTestChooser.class);
    @Nonnull
    private final String testName;
    @Nonnull
    private final ConsumableTestDefinition testDefinition;
    @Nonnull
    private final String[] rules;
    @Nonnull
    private final TestBucket[][] rangeToBucket;
    private final RuleEvaluator ruleEvaluator;

    TestRangeSelector(@Nonnull ExpressionFactory expressionFactory, @Nonnull FunctionMapper functionMapper, String testName, @Nonnull ConsumableTestDefinition testDefinition) {
        this(new RuleEvaluator(expressionFactory, functionMapper, testDefinition.getConstants()), testName, testDefinition);
    }

    TestRangeSelector(@Nonnull RuleEvaluator ruleEvaluator, @Nonnull String testName, @Nonnull ConsumableTestDefinition testDefinition) {
        this.ruleEvaluator = ruleEvaluator;
        this.testName = testName;
        this.testDefinition = testDefinition;
        HashMap bucketValueToTest = Maps.newHashMap();
        for (TestBucket testBucket : testDefinition.getBuckets()) {
            bucketValueToTest.put(testBucket.getValue(), testBucket);
        }
        List<Allocation> allocations = testDefinition.getAllocations();
        this.rangeToBucket = new TestBucket[allocations.size()][];
        this.rules = new String[allocations.size()];
        for (int i = 0; i < allocations.size(); ++i) {
            Allocation allocation = allocations.get(i);
            this.rules[i] = allocation.getRule();
            List<Range> ranges = allocation.getRanges();
            this.rangeToBucket[i] = new TestBucket[ranges.size()];
            for (int j = 0; j < ranges.size(); ++j) {
                this.rangeToBucket[i][j] = (TestBucket)bucketValueToTest.get(ranges.get(j).getBucketValue());
            }
        }
    }

    public TestBucket[] getBucketRange(int index) {
        return this.rangeToBucket[index];
    }

    public int findMatchingRule(@Nonnull Map<String, Object> values) {
        try {
            String rule = this.testDefinition.getRule();
            if (rule != null && !this.evaluateRule(rule, values)) {
                return -1;
            }
            for (int i = 0; i < this.rules.length; ++i) {
                if (!this.evaluateRule(this.rules[i], values)) continue;
                return i;
            }
        }
        catch (InvalidRuleException e) {
            LOGGER.error((Object)"Failed to evaluate test rules; ", (Throwable)e);
        }
        return -1;
    }

    private boolean evaluateRule(String rule, @Nonnull Map<String, Object> values) throws InvalidRuleException {
        try {
            return this.ruleEvaluator.evaluateBooleanRule(rule, values);
        }
        catch (RuntimeException e) {
            throw new InvalidRuleException(e, String.format("Error evaluating rule '%s' for test '%s': '%s'. Failing evaluation and continuing.", rule, this.testName, e.getMessage()));
        }
    }

    @Nonnull
    public String[] getRules() {
        return this.rules;
    }

    @Nonnull
    public ConsumableTestDefinition getTestDefinition() {
        return this.testDefinition;
    }

    @Nullable
    public TestBucket getTestBucket(int value) {
        for (TestBucket testBucket : this.testDefinition.getBuckets()) {
            if (testBucket.getValue() != value) continue;
            return testBucket;
        }
        return null;
    }

    @Nonnull
    public String getTestName() {
        return this.testName;
    }

    protected void printTestBuckets(@Nonnull PrintWriter writer, @Nonnull Map<String, String> parameters) {
        NumberFormat fmt = NumberFormat.getPercentInstance(Locale.US);
        fmt.setMaximumFractionDigits(2);
        writer.printf("{ ", new Object[0]);
        Iterator<Map.Entry<String, String>> iterator = parameters.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            writer.print(entry.getKey());
            writer.print("'");
            writer.print(entry.getValue());
            writer.print("'");
            if (!iterator.hasNext()) continue;
            writer.print(", ");
        }
        if (this.testDefinition.getRule() != null) {
            writer.printf(", rule='%s'", this.testDefinition.getRule());
        }
        String separator = this.testDefinition.getAllocations().size() > 1 ? ",\n\t" : ", ";
        List<Allocation> allocations = this.testDefinition.getAllocations();
        for (Allocation allocation : allocations) {
            writer.print(separator);
            if (allocation.getRule() != null) {
                writer.printf("rule='%s', ", allocation.getRule());
            }
            List<Range> ranges = allocation.getRanges();
            for (int j = 0; j < ranges.size(); ++j) {
                if (j > 0) {
                    writer.print(", ");
                }
                Range range = ranges.get(j);
                writer.printf("%s%d='%s'", this.testName, range.getBucketValue(), fmt.format(range.getLength()));
            }
        }
        writer.print(" },");
    }
}

