/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common;

import com.google.common.collect.Lists;
import com.indeed.proctor.common.IncompatibleTestMatrixException;
import com.indeed.proctor.common.ProctorUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import org.apache.el.lang.ExpressionBuilder;
import org.apache.el.parser.Node;
import org.apache.log4j.Logger;

public class RuleVerifyUtils {
    private static final Logger LOGGER = Logger.getLogger(RuleVerifyUtils.class);

    private RuleVerifyUtils() {
    }

    public static void verifyRule(String testRule, boolean shouldEvaluate, ExpressionFactory expressionFactory, ELContext elContext, Set<String> absentIdentifiers) throws IncompatibleTestMatrixException {
        String bareRule = ProctorUtils.removeElExpressionBraces(testRule);
        if (!ProctorUtils.isEmptyWhitespace(bareRule)) {
            ValueExpression valueExpression = expressionFactory.createValueExpression(elContext, testRule, Boolean.class);
            if (shouldEvaluate) {
                try {
                    valueExpression.getValue(elContext);
                }
                catch (ELException e) {
                    Node node = ExpressionBuilder.createNode((String)testRule);
                    if (RuleVerifyUtils.isIgnorable(node, absentIdentifiers)) {
                        LOGGER.info((Object)String.format("Rule %s contains uninstantiated identifier(s) in %s, ignore the failure", testRule, absentIdentifiers), (Throwable)e);
                    }
                    throw e;
                }
            }
        }
    }

    private static boolean isIgnorable(Node node, Set<String> absentIdentifiers) {
        List<Node> leaves = RuleVerifyUtils.getLeafNodes(node);
        for (Node n : leaves) {
            String image = n.getImage();
            if (!absentIdentifiers.contains(image)) continue;
            return true;
        }
        return false;
    }

    private static List<Node> getLeafNodes(Node node) {
        ArrayList nodes = Lists.newArrayList();
        RuleVerifyUtils.find(node, nodes);
        return nodes;
    }

    private static void find(Node node, List<Node> res) {
        if (node.jjtGetNumChildren() > 0) {
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                RuleVerifyUtils.find(node.jjtGetChild(i), res);
            }
        } else {
            res.add(node);
        }
    }
}

