/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common;

import com.indeed.proctor.common.model.Payload;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum PayloadType {
    DOUBLE_VALUE("doubleValue", "Double", "getDoubleValue"),
    DOUBLE_ARRAY("doubleArray", "Double[]", "getDoubleArray"),
    LONG_VALUE("longValue", "Long", "getLongValue"),
    LONG_ARRAY("longArray", "Long[]", "getLongArray"),
    STRING_VALUE("stringValue", "String", "getStringValue"),
    STRING_ARRAY("stringArray", "String[]", "getStringArray"),
    MAP("map", "Map<String,Object>", "getMap");

    @Nonnull
    public final String payloadTypeName;
    @Nonnull
    public final String javaClassName;
    @Nonnull
    public final String javaAccessorName;

    private PayloadType(@Nonnull String payloadTypeName, String javaClassName, String javaAccessorName) {
        this.payloadTypeName = payloadTypeName;
        this.javaClassName = javaClassName;
        this.javaAccessorName = javaAccessorName;
    }

    public boolean payloadHasThisType(@Nullable Payload payload) {
        if (payload == null) {
            return false;
        }
        switch (this) {
            case DOUBLE_VALUE: {
                return payload.getDoubleValue() != null;
            }
            case DOUBLE_ARRAY: {
                return payload.getDoubleArray() != null;
            }
            case LONG_VALUE: {
                return payload.getLongValue() != null;
            }
            case LONG_ARRAY: {
                return payload.getLongArray() != null;
            }
            case STRING_VALUE: {
                return payload.getStringValue() != null;
            }
            case STRING_ARRAY: {
                return payload.getStringArray() != null;
            }
            case MAP: {
                return payload.getMap() != null;
            }
        }
        throw new IllegalStateException("Unknown payload type: " + (Object)((Object)this));
    }

    @Nonnull
    public static PayloadType payloadTypeForName(@Nonnull String payloadTypeName) throws IllegalArgumentException {
        for (PayloadType p : PayloadType.values()) {
            if (!payloadTypeName.equals(p.payloadTypeName)) continue;
            return p;
        }
        throw new IllegalArgumentException("Payload type name " + payloadTypeName + " is not in the list of standard values: " + PayloadType.allTypeNames().toString());
    }

    @Nonnull
    public static List<String> allTypeNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (PayloadType p : PayloadType.values()) {
            names.add(p.payloadTypeName);
        }
        return names;
    }
}

