/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common;

import com.indeed.proctor.common.IncompatibleTestMatrixException;
import com.indeed.proctor.common.MisconfiguredProctorConsumerException;
import com.indeed.proctor.common.MissingTestMatrixException;
import com.indeed.proctor.common.ProctorSpecification;
import com.indeed.proctor.common.Serializers;
import com.indeed.proctor.common.SpecificationResult;
import com.indeed.proctor.common.StringProctorLoader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;

public class TestMatrixVerifier {
    private static final Logger LOGGER = Logger.getLogger(TestMatrixVerifier.class);
    @Nonnull
    private static final ObjectMapper OBJECT_MAPPER = Serializers.strict();
    @Nonnull
    private final String source;
    @Nonnull
    private final String testMatrixJson;
    private final int connectionTimeout;

    public TestMatrixVerifier(@Nonnull String source, @Nonnull String testMatrixJson, int connectionTimeout) {
        this.source = source;
        this.testMatrixJson = testMatrixJson;
        this.connectionTimeout = connectionTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifyArtifact(@Nonnull URL requiredTestsUrl) throws IncompatibleTestMatrixException, IOException, MisconfiguredProctorConsumerException, MissingTestMatrixException {
        HttpURLConnection urlConnection = (HttpURLConnection)requiredTestsUrl.openConnection();
        urlConnection.setReadTimeout(this.connectionTimeout);
        InputStream inputStream = null;
        try {
            inputStream = urlConnection.getInputStream();
            SpecificationResult specResults = (SpecificationResult)OBJECT_MAPPER.readValue(inputStream, SpecificationResult.class);
            String errorMessage = specResults.getError();
            if (errorMessage != null) {
                throw new MisconfiguredProctorConsumerException(errorMessage);
            }
            ProctorSpecification spec = specResults.getSpecification();
            boolean bl = this.verifyArtifact(spec);
            return bl;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)("Unable to close input stream from " + requiredTestsUrl), (Throwable)e);
                }
            }
        }
    }

    private boolean verifyArtifact(ProctorSpecification spec) throws IOException, IncompatibleTestMatrixException, MissingTestMatrixException {
        StringProctorLoader loader = new StringProctorLoader(spec, this.source, this.testMatrixJson);
        loader.doLoad();
        return true;
    }

    public static void main(@Nonnull String[] args) throws IOException, IncompatibleTestMatrixException, MisconfiguredProctorConsumerException, MissingTestMatrixException {
        if (args.length != 2) {
            System.err.println("Usage: java " + TestMatrixVerifier.class.getCanonicalName() + " <required-tests.json> <test-matrix.json>");
            System.exit(-2);
        }
        String specificationFile = args[0];
        String testMatrixFilename = args[1];
        String testMatrixJson = TestMatrixVerifier.readTestMatrix(testMatrixFilename);
        TestMatrixVerifier verifier = new TestMatrixVerifier(testMatrixFilename, testMatrixJson, 15000);
        ProctorSpecification spec = (ProctorSpecification)OBJECT_MAPPER.readValue(new File(specificationFile), ProctorSpecification.class);
        verifier.verifyArtifact(spec);
        LOGGER.info((Object)("Success verifying testMatrix against " + specificationFile));
    }

    @Nonnull
    private static String readTestMatrix(String testMatrixFilename) throws IOException {
        int read;
        File testMatrixFile = new File(testMatrixFilename);
        StringBuilder testMatrixJson = new StringBuilder();
        char[] buffer = new char[2048];
        FileReader reader = new FileReader(testMatrixFile);
        while ((read = reader.read(buffer)) != -1) {
            if (read <= 0) continue;
            testMatrixJson.append(buffer, 0, read);
        }
        return testMatrixJson.toString();
    }
}

