/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;

public class ProctorLoadResult {
    @Nonnull
    private final Set<String> testsWithErrors;
    @Nonnull
    private final Set<String> missingTests;
    private final boolean verifiedRules;
    private static final ProctorLoadResult EMPTY = ProctorLoadResult.newBuilder().build();

    public ProctorLoadResult(@Nonnull Set<String> testsWithErrors, @Nonnull Set<String> missingTests) {
        this.testsWithErrors = testsWithErrors;
        this.missingTests = missingTests;
        this.verifiedRules = false;
    }

    public ProctorLoadResult(@Nonnull Set<String> testsWithErrors, @Nonnull Set<String> missingTests, boolean verifiedRules) {
        this.testsWithErrors = testsWithErrors;
        this.missingTests = missingTests;
        this.verifiedRules = verifiedRules;
    }

    @Nonnull
    public Set<String> getTestsWithErrors() {
        return this.testsWithErrors;
    }

    @Nonnull
    public Set<String> getMissingTests() {
        return this.missingTests;
    }

    public boolean getVerifiedRules() {
        return this.verifiedRules;
    }

    public boolean hasInvalidTests() {
        return !this.testsWithErrors.isEmpty() || !this.missingTests.isEmpty();
    }

    @Nonnull
    public static ProctorLoadResult emptyResult() {
        return EMPTY;
    }

    @Nonnull
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private ImmutableSet.Builder<String> testsWithErrors = ImmutableSet.builder();
        private ImmutableSet.Builder<String> missingTests = ImmutableSet.builder();
        private boolean verifiedRules = false;

        private Builder() {
        }

        @Nonnull
        public Builder recordError(String testName) {
            this.testsWithErrors.add((Object)testName);
            return this;
        }

        @Nonnull
        public Builder recordMissing(String testName) {
            this.missingTests.add((Object)testName);
            return this;
        }

        @Nonnull
        public Builder recordAllMissing(Collection<String> testNames) {
            this.missingTests.addAll(testNames);
            return this;
        }

        public Builder recordVerifiedRules(boolean verifiedRulesInput) {
            this.verifiedRules = verifiedRulesInput;
            return this;
        }

        @Nonnull
        public ProctorLoadResult build() {
            return new ProctorLoadResult((Set<String>)this.testsWithErrors.build(), (Set<String>)this.missingTests.build(), this.verifiedRules);
        }
    }
}

