/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.indeed.proctor.common.model.ConsumableTestDefinition;
import com.indeed.proctor.common.model.TestDependency;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class TestDependencies {
    private TestDependencies() {
    }

    public static Map<String, String> validateDependenciesAndReturnReasons(Map<String, ConsumableTestDefinition> testDefinitions) {
        HashSet<String> traversed = new HashSet<String>();
        HashMap<String, String> errorReasonMap = new HashMap<String, String>();
        for (String testName : TestDependencies.traverseDependencyTreesBFS(testDefinitions, TestDependencies.testsWithoutDependencyOrUnknownDependency(testDefinitions))) {
            TestDependency dependsOn = testDefinitions.get(testName).getDependsOn();
            boolean isParentInvalid = dependsOn != null && errorReasonMap.containsKey(dependsOn.getTestName());
            Optional<String> errorReason = TestDependencies.validateDependencyAndReturnReason(testName, testDefinitions.get(testName), testDefinitions);
            traversed.add(testName);
            if (errorReason.isPresent()) {
                errorReasonMap.put(testName, errorReason.get());
                continue;
            }
            if (!isParentInvalid) continue;
            errorReasonMap.put(testName, "A test " + testName + " directly or indirectly depends on an invalid test");
        }
        for (String testName : testDefinitions.keySet()) {
            if (traversed.contains(testName)) continue;
            errorReasonMap.put(testName, "A test " + testName + " depends on a test with circular dependency");
        }
        return ImmutableMap.copyOf(errorReasonMap);
    }

    public static Optional<String> validateDependencyAndReturnReason(String testName, ConsumableTestDefinition definition, Map<String, ConsumableTestDefinition> testDefinitions) {
        TestDependency dependsOn = definition.getDependsOn();
        if (dependsOn == null) {
            return Optional.empty();
        }
        String parentName = dependsOn.getTestName();
        if (testName.equals(parentName)) {
            return Optional.of("A test " + testName + " depends on itself");
        }
        ConsumableTestDefinition parentDefinition = testDefinitions.get(parentName);
        if (parentDefinition == null) {
            return Optional.of("A test " + testName + " depends on an unknown or incompatible test " + dependsOn.getTestName());
        }
        if (!definition.getTestType().isAllowedDependency(parentDefinition.getTestType())) {
            return Optional.of("A test " + testName + " depends on " + parentName + " with different test type: expected " + definition.getTestType().allowedDependenciesToString() + " but " + parentDefinition.getTestType());
        }
        if (Objects.equals(definition.getSalt(), parentDefinition.getSalt())) {
            return Optional.of("A test " + testName + " depends on " + parentName + " with the same salt: " + parentDefinition.getSalt());
        }
        if (dependsOn.getBucketValue() < 0) {
            return Optional.of("A test " + testName + " depends on negative bucket value " + dependsOn.getBucketValue() + " of " + dependsOn.getTestName());
        }
        boolean isBucketDefined = parentDefinition.getBuckets().stream().anyMatch(x -> x.getValue() == dependsOn.getBucketValue());
        if (!isBucketDefined) {
            return Optional.of("A test " + testName + " depends on an undefined bucket " + dependsOn.getBucketValue());
        }
        return Optional.empty();
    }

    public static List<String> determineEvaluationOrder(Map<String, ConsumableTestDefinition> testDefinitions) {
        List<String> evaluationOrder = TestDependencies.traverseDependencyTreesBFS(testDefinitions, TestDependencies.testsWithoutDependency(testDefinitions));
        if (evaluationOrder.size() != testDefinitions.size()) {
            throw new IllegalArgumentException("Detected invalid dependency links. Unable to determine order");
        }
        return evaluationOrder;
    }

    public static int computeMaximumDependencyChains(Map<String, ConsumableTestDefinition> testDefinitions, String testName) {
        HashMap<String, Integer> depthMap = new HashMap<String, Integer>();
        for (String name : TestDependencies.traverseDependencyTreesBFS(testDefinitions, (Set<String>)ImmutableSet.of((Object)testName))) {
            ConsumableTestDefinition definition = testDefinitions.get(name);
            if (testName.equals(name) || definition.getDependsOn() == null) {
                depthMap.put(name, 0);
                continue;
            }
            depthMap.put(name, (Integer)depthMap.get(definition.getDependsOn().getTestName()) + 1);
        }
        int childDepth = depthMap.values().stream().max(Comparator.naturalOrder()).orElse(0);
        int parentNums = TestDependencies.computeTransitiveDependencies(testDefinitions, (Set<String>)ImmutableSet.of((Object)testName)).size() - 1;
        return parentNums + childDepth;
    }

    public static Set<String> computeTransitiveDependencies(Map<String, ConsumableTestDefinition> testDefinitions, Set<String> testNames) {
        testNames.stream().filter(testName -> !testDefinitions.containsKey(testName)).findAny().ifPresent(testName -> {
            throw new IllegalArgumentException("BUG: unknown test name " + testName + " is given");
        });
        ArrayDeque<String> testNameQueue = new ArrayDeque<String>(testNames);
        HashSet<String> transitiveDependencies = new HashSet<String>(testNames);
        while (!testNameQueue.isEmpty()) {
            String parentTestName;
            String testName2 = (String)testNameQueue.poll();
            ConsumableTestDefinition testDefinition = testDefinitions.get(testName2);
            if (testDefinition == null) {
                throw new IllegalArgumentException("Detected dependency on an unknown test " + testName2);
            }
            TestDependency dependsOn = testDefinition.getDependsOn();
            if (dependsOn == null || transitiveDependencies.contains(parentTestName = dependsOn.getTestName())) continue;
            testNameQueue.add(parentTestName);
            transitiveDependencies.add(parentTestName);
        }
        return ImmutableSet.copyOf(transitiveDependencies);
    }

    private static List<String> traverseDependencyTreesBFS(Map<String, ConsumableTestDefinition> testDefinitions, Set<String> sourceTestNames) {
        sourceTestNames.stream().filter(testName -> !testDefinitions.containsKey(testName)).findAny().ifPresent(testName -> {
            throw new IllegalArgumentException("BUG: unknown test name " + testName + " is given");
        });
        HashMultimap parentToChildrenMap = HashMultimap.create();
        testDefinitions.forEach((arg_0, arg_1) -> TestDependencies.lambda$traverseDependencyTreesBFS$5((Multimap)parentToChildrenMap, arg_0, arg_1));
        ArrayDeque<String> testNameQueue = new ArrayDeque<String>(sourceTestNames);
        HashSet<String> testNameSet = new HashSet<String>();
        ImmutableList.Builder builder = ImmutableList.builder();
        while (!testNameQueue.isEmpty()) {
            String testName2 = (String)testNameQueue.poll();
            if (!testNameSet.add(testName2)) {
                throw new IllegalArgumentException("BUG: circular dependency detect around " + testName2);
            }
            builder.add((Object)testName2);
            testNameQueue.addAll(parentToChildrenMap.get((Object)testName2));
        }
        return builder.build();
    }

    private static Set<String> testsWithoutDependency(Map<String, ConsumableTestDefinition> testDefinitions) {
        return testDefinitions.entrySet().stream().filter(entry -> ((ConsumableTestDefinition)entry.getValue()).getDependsOn() == null).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private static Set<String> testsWithoutDependencyOrUnknownDependency(Map<String, ConsumableTestDefinition> testDefinitions) {
        return testDefinitions.entrySet().stream().filter(entry -> ((ConsumableTestDefinition)entry.getValue()).getDependsOn() == null || !testDefinitions.containsKey(((ConsumableTestDefinition)entry.getValue()).getDependsOn().getTestName())).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private static /* synthetic */ void lambda$traverseDependencyTreesBFS$5(Multimap parentToChildrenMap, String testName, ConsumableTestDefinition definition) {
        if (definition.getDependsOn() != null) {
            parentToChildrenMap.put((Object)definition.getDependsOn().getTestName(), (Object)testName);
        }
    }
}

