/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.shaded.org.apache.el7.util;

import com.indeed.shaded.javax.el7.MethodNotFoundException;
import com.indeed.shaded.org.apache.el7.util.MessageFactory;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ReflectionUtil {
    protected static final String[] PRIMITIVE_NAMES = new String[]{"boolean", "byte", "char", "double", "float", "int", "long", "short", "void"};
    protected static final Class<?>[] PRIMITIVES = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE, Void.TYPE};

    private ReflectionUtil() {
    }

    public static Class<?> forName(String name) throws ClassNotFoundException {
        if (null == name || "".equals(name)) {
            return null;
        }
        Class<?> c = ReflectionUtil.forNamePrimitive(name);
        if (c == null) {
            if (name.endsWith("[]")) {
                String nc = name.substring(0, name.length() - 2);
                c = Class.forName(nc, true, Thread.currentThread().getContextClassLoader());
                c = Array.newInstance(c, 0).getClass();
            } else {
                c = Class.forName(name, true, Thread.currentThread().getContextClassLoader());
            }
        }
        return c;
    }

    protected static Class<?> forNamePrimitive(String name) {
        int p;
        if (name.length() <= 8 && (p = Arrays.binarySearch(PRIMITIVE_NAMES, name)) >= 0) {
            return PRIMITIVES[p];
        }
        return null;
    }

    public static Class<?>[] toTypeArray(String[] s) throws ClassNotFoundException {
        if (s == null) {
            return null;
        }
        Class[] c = new Class[s.length];
        for (int i = 0; i < s.length; ++i) {
            c[i] = ReflectionUtil.forName(s[i]);
        }
        return c;
    }

    public static String[] toTypeNameArray(Class<?>[] c) {
        if (c == null) {
            return null;
        }
        String[] s = new String[c.length];
        for (int i = 0; i < c.length; ++i) {
            s[i] = c[i].getName();
        }
        return s;
    }

    public static Method getMethod(Object base, Object property, Class<?>[] paramTypes) throws MethodNotFoundException {
        if (base == null || property == null) {
            throw new MethodNotFoundException(MessageFactory.get("error.method.notfound", base, property, ReflectionUtil.paramString(paramTypes)));
        }
        String methodName = property instanceof String ? (String)property : property.toString();
        int paramCount = paramTypes == null ? 0 : paramTypes.length;
        Method[] methods = base.getClass().getMethods();
        HashMap<Method, Integer> candidates = new HashMap<Method, Integer>();
        for (Method m : methods) {
            Class<?>[] mParamTypes;
            int mParamCount;
            if (!m.getName().equals(methodName) || paramCount != (mParamCount = (mParamTypes = m.getParameterTypes()) == null ? 0 : mParamTypes.length) && (!m.isVarArgs() || paramCount < mParamCount)) continue;
            int exactMatch = 0;
            boolean noMatch = false;
            for (int i = 0; i < mParamCount; ++i) {
                if (mParamTypes[i].equals(paramTypes[i])) {
                    ++exactMatch;
                    continue;
                }
                if (i == mParamCount - 1 && m.isVarArgs()) {
                    Class<?> varType = mParamTypes[i].getComponentType();
                    for (int j = i; j < paramCount && ReflectionUtil.isAssignableFrom(paramTypes[j], varType); ++j) {
                    }
                    continue;
                }
                if (ReflectionUtil.isAssignableFrom(paramTypes[i], mParamTypes[i])) continue;
                noMatch = true;
                break;
            }
            if (noMatch) continue;
            if (exactMatch == paramCount) {
                return m;
            }
            candidates.put(m, exactMatch);
        }
        int bestMatch = 0;
        Method match = null;
        boolean multiple = false;
        for (Map.Entry entry : candidates.entrySet()) {
            if ((Integer)entry.getValue() > bestMatch || match == null) {
                bestMatch = (Integer)entry.getValue();
                match = (Method)entry.getKey();
                multiple = false;
                continue;
            }
            if ((Integer)entry.getValue() != bestMatch) continue;
            multiple = true;
        }
        if (multiple && (match = bestMatch == paramCount - 1 ? ReflectionUtil.resolveAmbiguousMethod(candidates.keySet(), paramTypes) : null) == null) {
            throw new MethodNotFoundException(MessageFactory.get("error.method.ambiguous", base, property, ReflectionUtil.paramString(paramTypes)));
        }
        if (match == null) {
            throw new MethodNotFoundException(MessageFactory.get("error.method.notfound", base, property, ReflectionUtil.paramString(paramTypes)));
        }
        return match;
    }

    private static Method resolveAmbiguousMethod(Set<Method> candidates, Class<?>[] paramTypes) {
        Method m = candidates.iterator().next();
        int nonMatchIndex = 0;
        Class<Object> nonMatchClass = null;
        for (int i = 0; i < paramTypes.length; ++i) {
            if (m.getParameterTypes()[i] == paramTypes[i]) continue;
            nonMatchIndex = i;
            nonMatchClass = paramTypes[i];
            break;
        }
        for (Method c : candidates) {
            if (c.getParameterTypes()[nonMatchIndex] != paramTypes[nonMatchIndex]) continue;
            return null;
        }
        for (nonMatchClass = nonMatchClass.getSuperclass(); nonMatchClass != null; nonMatchClass = nonMatchClass.getSuperclass()) {
            for (Method c : candidates) {
                if (!c.getParameterTypes()[nonMatchIndex].equals(nonMatchClass)) continue;
                return c;
            }
        }
        return null;
    }

    private static boolean isAssignableFrom(Class<?> src, Class<?> target) {
        Class<Object> targetClass = target.isPrimitive() ? (target == Boolean.TYPE ? Boolean.class : (target == Character.TYPE ? Character.class : (target == Byte.TYPE ? Byte.class : (target == Short.TYPE ? Short.class : (target == Integer.TYPE ? Integer.class : (target == Long.TYPE ? Long.class : (target == Float.TYPE ? Float.class : Double.class))))))) : target;
        return targetClass.isAssignableFrom(src);
    }

    protected static final String paramString(Class<?>[] types) {
        if (types != null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < types.length; ++i) {
                sb.append(types[i].getName()).append(", ");
            }
            if (sb.length() > 2) {
                sb.setLength(sb.length() - 2);
            }
            return sb.toString();
        }
        return null;
    }
}

