/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.consumer.gen.ant;

import com.google.common.base.Strings;
import com.indeed.proctor.consumer.gen.CodeGenException;
import com.indeed.proctor.consumer.gen.TestGroupsGenerator;
import java.io.File;
import java.io.FileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class TestGroupsGeneratorTask
extends Task {
    private final TestGroupsGenerator gen = new TestGroupsGenerator();
    private String input;
    private String target;
    private String packageName;
    private String groupsClass;
    private String groupsManagerClass;
    private String specificationOutput;
    private static final Logger LOGGER = Logger.getLogger(TestGroupsGeneratorTask.class);

    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getGroupsClass() {
        return this.groupsClass;
    }

    public void setGroupsClass(String groupsClass) {
        this.groupsClass = groupsClass;
    }

    public String getGroupsManagerClass() {
        return this.groupsManagerClass;
    }

    public void setGroupsManagerClass(String groupsManagerClass) {
        this.groupsManagerClass = groupsManagerClass;
    }

    public String getSpecificationOutput() {
        return this.specificationOutput;
    }

    public void setSpecificationOutput(String specificationOutput) {
        this.specificationOutput = specificationOutput;
    }

    private void totalSpecificationGenerator(File dir) throws CodeGenException {
        if (dir.equals(null)) {
            throw new CodeGenException("input directory creates null file");
        }
        File[] providedContextFiles = dir.listFiles((FileFilter)FileFilterUtils.andFileFilter((IOFileFilter)FileFilterUtils.fileFileFilter(), (IOFileFilter)FileFilterUtils.nameFileFilter((String)"providedcontext.json")));
        if (providedContextFiles.length != 1) {
            throw new CodeGenException("Incorrect amount of providedcontext.json in specified input folder");
        }
        new File(this.specificationOutput.substring(0, this.specificationOutput.lastIndexOf(File.separator))).mkdirs();
        File specificationOutputFile = new File(this.specificationOutput);
        File output = TestGroupsGenerator.makeTotalSpecification((File)dir, (String)specificationOutputFile.getParent(), (String)specificationOutputFile.getName());
        this.gen.generate(output.getPath(), this.target, this.packageName, this.groupsClass, this.groupsManagerClass);
    }

    public void execute() throws BuildException {
        File inputFile = new File(this.input);
        if (inputFile == null) {
            LOGGER.error((Object)"input not substituted with configured value");
            return;
        }
        if (inputFile.isDirectory()) {
            if (!Strings.isNullOrEmpty((String)this.getSpecificationOutput())) {
                try {
                    this.totalSpecificationGenerator(inputFile);
                }
                catch (CodeGenException e) {
                    throw new BuildException("Could not create total specification", (Throwable)e);
                }
            }
            throw new BuildException("Undefined output folder for generated specification");
        }
        try {
            this.gen.generate(this.input, this.target, this.packageName, this.groupsClass, this.groupsManagerClass);
        }
        catch (CodeGenException ex) {
            throw new BuildException("Unable to generate code " + ex.toString(), (Throwable)ex);
        }
    }
}

