/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.lsmtree.recordlog;

import com.google.common.io.ByteStreams;
import com.google.common.primitives.Ints;
import com.indeed.lsmtree.recordlog.ConsistencyException;
import com.indeed.lsmtree.recordlog.RecordFile;
import com.indeed.util.io.BufferedFileDataOutputStream;
import com.indeed.util.io.UnsafeByteArrayOutputStream;
import com.indeed.util.mmap.MMapBuffer;
import com.indeed.util.mmap.Memory;
import com.indeed.util.mmap.MemoryDataInput;
import com.indeed.util.serialization.Serializer;
import fj.data.Option;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.zip.CRC32;
import org.apache.commons.lang.mutable.MutableLong;
import org.apache.log4j.Logger;

public final class BasicRecordFile<E>
implements RecordFile<E> {
    private static final byte[] CRC_SEED = Ints.toByteArray((int)-1029503378);
    private static final Logger log = Logger.getLogger(BasicRecordFile.class);
    final MMapBuffer buffer;
    final Memory memory;
    private final File file;
    private final Serializer<E> serializer;

    public BasicRecordFile(File file, Serializer<E> serializer) throws IOException {
        this.file = file;
        this.serializer = serializer;
        this.buffer = new MMapBuffer(file, FileChannel.MapMode.READ_ONLY, ByteOrder.BIG_ENDIAN);
        this.memory = this.buffer.memory();
    }

    @Override
    public void close() throws IOException {
        this.buffer.close();
    }

    @Override
    public E get(long address) throws IOException {
        Option<E> option = this.readAndCheck(address, null);
        if (option.isNone()) {
            throw new IOException("there is not a valid record at address " + address + " in file " + this.file.getAbsolutePath());
        }
        return (E)option.some();
    }

    @Override
    public RecordFile.Reader<E> reader() throws IOException {
        return new Reader();
    }

    @Override
    public RecordFile.Reader<E> reader(long address) throws IOException {
        return new Reader(address);
    }

    private Option<E> readAndCheck(long address, MutableLong nextElementStart) throws IOException {
        if (address + 4L > this.memory.length()) {
            throw new ConsistencyException("not enough bytes in file");
        }
        int length = this.memory.getInt(address);
        if (length < 0) {
            return Option.none();
        }
        if (address + 8L > this.memory.length()) {
            throw new ConsistencyException("not enough bytes in file");
        }
        if (address + 8L + (long)length > this.memory.length()) {
            throw new ConsistencyException("not enough bytes in file");
        }
        int checksum = this.memory.getInt(address + 4L);
        MemoryDataInput in = new MemoryDataInput(this.memory);
        in.seek(address + 8L);
        CRC32 crc32 = new CRC32();
        crc32.update(CRC_SEED);
        byte[] bytes = new byte[length];
        in.readFully(bytes);
        crc32.update(bytes);
        if ((int)crc32.getValue() != checksum) {
            throw new ConsistencyException("checksum for record does not match: expected " + checksum + " actual " + (int)crc32.getValue());
        }
        Object ret = this.serializer.read((DataInput)ByteStreams.newDataInput((byte[])bytes));
        if (nextElementStart != null) {
            nextElementStart.setValue(address + 8L + (long)length);
        }
        return Option.some((Object)ret);
    }

    public static final class Writer<E>
    implements RecordFile.Writer<E> {
        final BufferedFileDataOutputStream out;
        private final Serializer<E> serializer;

        public Writer(File file, Serializer<E> serializer) throws FileNotFoundException {
            this.serializer = serializer;
            this.out = new BufferedFileDataOutputStream(file, ByteOrder.BIG_ENDIAN, 65536);
        }

        @Override
        public long append(E entry) throws IOException {
            UnsafeByteArrayOutputStream bytes = new UnsafeByteArrayOutputStream();
            this.serializer.write(entry, (DataOutput)new DataOutputStream((OutputStream)bytes));
            long start = this.out.position();
            this.out.writeInt(bytes.size());
            CRC32 checksum = new CRC32();
            checksum.update(CRC_SEED);
            checksum.update(bytes.getByteArray(), 0, bytes.size());
            this.out.writeInt((int)checksum.getValue());
            this.out.write(bytes.getByteArray(), 0, bytes.size());
            return start;
        }

        @Override
        public void close() throws IOException {
            this.out.writeInt(-1);
            this.out.sync();
            this.out.close();
        }

        public void sync() throws IOException {
            this.out.sync();
        }
    }

    private final class Reader
    implements RecordFile.Reader<E> {
        MutableLong position;
        E e;
        boolean done = false;

        private Reader() {
            this(0L);
        }

        private Reader(long address) {
            this.position = new MutableLong(address);
        }

        @Override
        public boolean next() throws IOException {
            try {
                Option option = BasicRecordFile.this.readAndCheck(this.position.longValue(), this.position);
                if (option.isNone()) {
                    this.done = true;
                    return false;
                }
                this.e = option.some();
            }
            catch (ConsistencyException e) {
                this.done = true;
                log.warn((Object)("reading next record in " + BasicRecordFile.this.file.getAbsolutePath() + " failed with exception"), (Throwable)e);
                return false;
            }
            return true;
        }

        @Override
        public long getPosition() {
            return this.position.longValue();
        }

        @Override
        public E get() {
            return this.e;
        }

        @Override
        public void close() throws IOException {
        }
    }
}

