/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.lsmtree.core;

import com.indeed.lsmtree.core.StorageType;
import com.indeed.lsmtree.core.Store;
import com.indeed.util.compress.CompressionCodec;
import com.indeed.util.serialization.Serializer;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import org.apache.commons.collections.comparators.ComparableComparator;
import org.apache.log4j.Logger;

public final class StoreBuilder<K, V> {
    private static final Logger log = Logger.getLogger(StoreBuilder.class);
    private final File root;
    private final Serializer<K> keySerializer;
    private final Serializer<V> valueSerializer;
    private Comparator<K> comparator = new ComparableComparator();
    private long maxVolatileGenerationSize = 0x800000L;
    private StorageType storageType = StorageType.INLINE;
    private CompressionCodec codec = null;
    private boolean readOnly = false;
    private boolean dedicatedPartition = false;
    private long reservedSpaceThreshold = 0x10000000L;
    private boolean mlockFiles = false;
    private boolean mlockBloomFilters = false;
    private long bloomFilterMemory = 0x2000000L;

    public StoreBuilder(File root, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        this.root = root;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
    }

    public Comparator<K> getComparator() {
        return this.comparator;
    }

    public StoreBuilder<K, V> setComparator(Comparator<K> comparator) {
        this.comparator = comparator;
        return this;
    }

    public long getMaxVolatileGenerationSize() {
        return this.maxVolatileGenerationSize;
    }

    public StoreBuilder<K, V> setMaxVolatileGenerationSize(long maxVolatileGenerationSize) {
        this.maxVolatileGenerationSize = maxVolatileGenerationSize;
        return this;
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    public StoreBuilder<K, V> setStorageType(StorageType storageType) {
        this.storageType = storageType;
        return this;
    }

    public CompressionCodec getCodec() {
        return this.codec;
    }

    public StoreBuilder<K, V> setCodec(CompressionCodec codec) {
        this.codec = codec;
        return this;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public StoreBuilder<K, V> setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public boolean isDedicatedPartition() {
        return this.dedicatedPartition;
    }

    public StoreBuilder<K, V> setDedicatedPartition(boolean dedicatedPartition) {
        this.dedicatedPartition = dedicatedPartition;
        return this;
    }

    public long getReservedSpaceThreshold() {
        return this.reservedSpaceThreshold;
    }

    public StoreBuilder<K, V> setReservedSpaceThreshold(long reservedSpaceThreshold) {
        this.reservedSpaceThreshold = reservedSpaceThreshold;
        return this;
    }

    public boolean isMlockFiles() {
        return this.mlockFiles;
    }

    public StoreBuilder<K, V> setMlockFiles(boolean mlockFiles) {
        this.mlockFiles = mlockFiles;
        return this;
    }

    public boolean isMlockBloomFilters() {
        return this.mlockBloomFilters;
    }

    public StoreBuilder<K, V> setMlockBloomFilters(boolean mlockBloomFilters) {
        this.mlockBloomFilters = mlockBloomFilters;
        return this;
    }

    public long getBloomFilterMemory() {
        return this.bloomFilterMemory;
    }

    public StoreBuilder<K, V> setBloomFilterMemory(long bloomFilterMemory) {
        this.bloomFilterMemory = bloomFilterMemory;
        return this;
    }

    public Store<K, V> build() throws IOException {
        return new Store<K, V>(this.root, this.keySerializer, this.valueSerializer, this.comparator, this.maxVolatileGenerationSize, this.storageType, this.codec, this.readOnly, this.dedicatedPartition, this.reservedSpaceThreshold, this.mlockFiles, this.bloomFilterMemory, this.mlockBloomFilters);
    }
}

