/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.log4j;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import net.logstash.log4j.data.HostData;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public class JSONEventLayoutV0
extends Layout {
    private static final ObjectMapper JSON = new ObjectMapper().configure(JsonGenerator.Feature.ESCAPE_NON_ASCII, true);
    private boolean locationInfo = false;
    private String tags;
    private boolean ignoreThrowable;
    private boolean activeIgnoreThrowable = this.ignoreThrowable = false;
    private String hostname = new HostData().getHostName();
    private String threadName;
    private long timestamp;
    private String ndc;
    private Map mdc;
    private LocationInfo info;
    private HashMap<String, Object> fieldData;
    private HashMap<String, Object> exceptionInformation;
    private Map logstashEvent;
    public static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    public static final FastDateFormat ISO_DATETIME_TIME_ZONE_FORMAT_WITH_MILLIS = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", (TimeZone)UTC);

    public static String dateFormat(long timestamp) {
        return ISO_DATETIME_TIME_ZONE_FORMAT_WITH_MILLIS.format(timestamp);
    }

    public JSONEventLayoutV0() {
        this(true);
    }

    public JSONEventLayoutV0(boolean locationInfo) {
        this.locationInfo = locationInfo;
    }

    public String format(LoggingEvent loggingEvent) {
        this.threadName = loggingEvent.getThreadName();
        this.timestamp = loggingEvent.getTimeStamp();
        this.fieldData = new HashMap();
        this.exceptionInformation = new HashMap();
        this.mdc = loggingEvent.getProperties();
        this.ndc = loggingEvent.getNDC();
        this.logstashEvent = new HashMap();
        this.logstashEvent.put("@source_host", this.hostname);
        this.logstashEvent.put("@message", loggingEvent.getRenderedMessage());
        this.logstashEvent.put("@timestamp", JSONEventLayoutV0.dateFormat(this.timestamp));
        if (loggingEvent.getThrowableInformation() != null) {
            ThrowableInformation throwableInformation = loggingEvent.getThrowableInformation();
            if (throwableInformation.getThrowable().getClass().getCanonicalName() != null) {
                this.exceptionInformation.put("exception_class", throwableInformation.getThrowable().getClass().getCanonicalName());
            }
            if (throwableInformation.getThrowable().getMessage() != null) {
                this.exceptionInformation.put("exception_message", throwableInformation.getThrowable().getMessage());
            }
            if (throwableInformation.getThrowableStrRep() != null) {
                String stackTrace = StringUtils.join((Object[])throwableInformation.getThrowableStrRep(), (String)"\n");
                this.exceptionInformation.put("stacktrace", stackTrace);
            }
            this.addFieldData("exception", this.exceptionInformation);
        }
        if (this.locationInfo) {
            this.info = loggingEvent.getLocationInformation();
            this.addFieldData("file", this.info.getFileName());
            this.addFieldData("line_number", this.info.getLineNumber());
            this.addFieldData("class", this.info.getClassName());
            this.addFieldData("method", this.info.getMethodName());
        }
        this.addFieldData("loggerName", loggingEvent.getLoggerName());
        this.addFieldData("mdc", this.mdc);
        this.addFieldData("ndc", this.ndc);
        this.addFieldData("level", loggingEvent.getLevel().toString());
        this.addFieldData("threadName", this.threadName);
        this.logstashEvent.put("@fields", this.fieldData);
        return this.safeString(this.logstashEvent) + "\n";
    }

    private String safeString(Map map) {
        try {
            return JSON.writeValueAsString((Object)map);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace(System.err);
            return "{}";
        }
    }

    public boolean ignoresThrowable() {
        return this.ignoreThrowable;
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    public void setLocationInfo(boolean locationInfo) {
        this.locationInfo = locationInfo;
    }

    public void activateOptions() {
        this.activeIgnoreThrowable = this.ignoreThrowable;
    }

    private void addFieldData(String keyname, Object keyval) {
        if (null != keyval) {
            this.fieldData.put(keyname, keyval);
        }
    }
}

