/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.log4j;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Date;
import java.util.Map;
import net.logstash.log4j.data.HostData;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public class JSONEventLayout
extends Layout {
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(JsonGenerator.Feature.ESCAPE_NON_ASCII, true);
    private boolean locationInfo = false;
    private boolean ignoreThrowable;
    private boolean activeIgnoreThrowable = this.ignoreThrowable = false;
    private final String hostname = new HostData().getHostName();
    public static final FastDateFormat ISO_DATETIME_TIME_ZONE_FORMAT_WITH_MILLIS = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZZ");

    public static String dateFormat(long timestamp) {
        return ISO_DATETIME_TIME_ZONE_FORMAT_WITH_MILLIS.format(new Date(timestamp));
    }

    public JSONEventLayout() {
        this(true);
    }

    public JSONEventLayout(boolean locationInfo) {
        this.locationInfo = locationInfo;
    }

    public String format(LoggingEvent loggingEvent) {
        long timestamp = loggingEvent.getTimeStamp();
        Map mdc = loggingEvent.getProperties();
        String ndc = loggingEvent.getNDC();
        ObjectNode eventNode = MAPPER.createObjectNode();
        eventNode.put("@source_host", this.hostname);
        eventNode.put("@message", loggingEvent.getRenderedMessage());
        eventNode.put("@timestamp", JSONEventLayout.dateFormat(timestamp));
        ObjectNode fieldsNode = MAPPER.createObjectNode();
        eventNode.put("@fields", (JsonNode)fieldsNode);
        if (loggingEvent.getThrowableInformation() != null) {
            ObjectNode exceptionNode = MAPPER.createObjectNode();
            ThrowableInformation throwableInformation = loggingEvent.getThrowableInformation();
            if (throwableInformation.getThrowable().getClass().getCanonicalName() != null) {
                exceptionNode.put("exception_class", throwableInformation.getThrowable().getClass().getCanonicalName());
            }
            if (throwableInformation.getThrowable().getMessage() != null) {
                exceptionNode.put("exception_message", throwableInformation.getThrowable().getMessage());
            }
            if (throwableInformation.getThrowableStrRep() != null) {
                String stackTrace = StringUtils.join((Object[])throwableInformation.getThrowableStrRep(), (String)"\n");
                exceptionNode.put("stacktrace", stackTrace);
            }
            fieldsNode.put("exception", (JsonNode)exceptionNode);
        }
        if (this.locationInfo) {
            LocationInfo info = loggingEvent.getLocationInformation();
            fieldsNode.put("file", info.getFileName());
            fieldsNode.put("line_number", info.getLineNumber());
            fieldsNode.put("class", info.getClassName());
            fieldsNode.put("method", info.getMethodName());
        }
        ObjectNode mdcNode = MAPPER.createObjectNode();
        for (Map.Entry entry : mdc.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            mdcNode.put(key, String.valueOf(value));
        }
        fieldsNode.put("mdc", (JsonNode)mdcNode);
        fieldsNode.put("ndc", ndc);
        fieldsNode.put("level", loggingEvent.getLevel().toString());
        return eventNode.toString() + "\n";
    }

    public boolean ignoresThrowable() {
        return this.ignoreThrowable;
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    public void setLocationInfo(boolean locationInfo) {
        this.locationInfo = locationInfo;
    }

    public void activateOptions() {
        this.activeIgnoreThrowable = this.ignoreThrowable;
    }
}

