/*
 * Decompiled with CFR 0.152.
 */
package com.imperva.ddc.core.query;

import com.imperva.ddc.core.commons.Utils;
import com.imperva.ddc.core.query.AccountNameType;
import com.imperva.ddc.core.query.CursorStatus;
import com.imperva.ddc.core.query.DestinationType;
import java.io.IOException;
import org.apache.directory.ldap.client.api.LdapConnection;

public class Endpoint
implements AutoCloseable {
    private AccountNameType osAccountNameMode = AccountNameType.DOMAIN_USERNAME;
    private String host;
    private String resolvedHost;
    private String secondaryHost;
    private String secondaryResolvedHost;
    private Integer port = 389;
    private Integer secondaryPort = 389;
    private String userAccountName;
    private String osUserName;
    private String domain;
    private String password;
    private String base;
    private Boolean securedConnection = false;
    private Boolean securedConnectionSecondary = false;
    private Boolean ignoreSSLValidations;
    private Object cookie;
    private CursorStatus hasNext = CursorStatus.STARTING;
    private DestinationType destinationType = DestinationType.NONE;
    private LdapConnection ldapConnection;

    public Endpoint() {
    }

    public Endpoint(Endpoint endpoint) {
        this.setBaseSearchPath(endpoint.getBaseSearchPath());
        this.domain = endpoint.getDomain();
        this.osUserName = endpoint.getOsUserName();
        this.setUserAccountName(endpoint.getUserAccountName());
        this.setPort(endpoint.getPort());
        this.setHost(endpoint.getHost());
        this.setSecuredConnection(endpoint.isSecuredConnection());
        this.setPassword(endpoint.getPassword());
        this.setSecondaryHost(endpoint.getSecondaryHost());
        this.setSecuredConnectionSecondary(endpoint.getSecuredConnectionSecondary());
        this.setSecondaryPort(endpoint.getSecondaryPort());
        this.setResolvedHost(endpoint.getResolvedHost());
        this.setSecondaryResolvedHost(endpoint.getSecondaryResolvedHost());
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getSecondaryHost() {
        return this.secondaryHost;
    }

    public void setSecondaryHost(String secondaryHost) {
        this.secondaryHost = secondaryHost;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Integer getSecondaryPort() {
        return this.secondaryPort;
    }

    public void setSecondaryPort(Integer secondaryPort) {
        this.secondaryPort = secondaryPort;
    }

    public String getUserAccountName() {
        return this.userAccountName;
    }

    public void setUserAccountName(String userAccountName) {
        if (Utils.isEmpty(userAccountName)) {
            this.userAccountName = null;
            this.osAccountNameMode = AccountNameType.NONE;
            return;
        }
        boolean isDistinguishedName = Utils.isDistinguishName(userAccountName);
        if (isDistinguishedName) {
            this.osAccountNameMode = AccountNameType.DN;
            this.domain = null;
            this.osUserName = null;
        } else {
            this.osAccountNameMode = AccountNameType.DOMAIN_USERNAME;
            if (Utils.isUserNameFullDomain(userAccountName)) {
                String[] splittedAccount = userAccountName.split("@");
                this.domain = splittedAccount[1];
                this.osUserName = splittedAccount[0];
            } else {
                String[] splittedAccount = userAccountName.split("\\\\");
                this.domain = splittedAccount[0];
                this.osUserName = splittedAccount[1];
            }
        }
        this.userAccountName = userAccountName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getBaseSearchPath() {
        return this.base;
    }

    public void setBaseSearchPath(String base) {
        this.base = base;
    }

    public Boolean isSecuredConnection() {
        return this.securedConnection;
    }

    public void setSecuredConnection(Boolean securedConnection) {
        this.securedConnection = securedConnection;
    }

    public Boolean getSecuredConnectionSecondary() {
        return this.securedConnectionSecondary;
    }

    public void setSecuredConnectionSecondary(Boolean securedConnectionSecondary) {
        this.securedConnectionSecondary = securedConnectionSecondary;
    }

    public Object getCookie() {
        return this.cookie;
    }

    public void setCookie(Object cookie) {
        this.cookie = cookie;
    }

    public CursorStatus hasNext() {
        return this.hasNext;
    }

    public void hasNext(CursorStatus hasNext) {
        this.hasNext = hasNext;
    }

    private String getDomain() {
        return this.domain;
    }

    public String getOsUserName() {
        return this.osUserName;
    }

    public AccountNameType getOsAccountNameMode() {
        return this.osAccountNameMode;
    }

    public DestinationType getDestinationType() {
        return this.destinationType;
    }

    public void setDestinationType(DestinationType destinationType) {
        this.destinationType = destinationType;
    }

    public Boolean isIgnoreSSLValidations() {
        return this.ignoreSSLValidations;
    }

    public void setIgnoreSSLValidations(boolean ignoreSSLValidations) {
        this.ignoreSSLValidations = ignoreSSLValidations;
    }

    public LdapConnection getLdapConnection() {
        return this.ldapConnection;
    }

    public void setLdapConnection(LdapConnection ldapConnection) {
        this.ldapConnection = ldapConnection;
    }

    public boolean isConnectionSucceeded() {
        return this.ldapConnection != null && this.ldapConnection.isConnected();
    }

    public boolean isValid() {
        if (Utils.isEmpty(this.host) || Utils.isEmpty(this.port) || Utils.isEmpty(this.password)) {
            return false;
        }
        return Utils.isEmpty(this.secondaryHost) || !Utils.isEmpty(this.secondaryPort);
    }

    @Override
    public void close() {
        if (this.ldapConnection != null && this.ldapConnection.isConnected()) {
            try {
                this.ldapConnection.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String getResolvedHost() {
        return this.resolvedHost;
    }

    public void setResolvedHost(String resolvedHost) {
        this.resolvedHost = resolvedHost;
    }

    public String getSecondaryResolvedHost() {
        return this.secondaryResolvedHost;
    }

    public void setSecondaryResolvedHost(String secondaryResolvedHost) {
        this.secondaryResolvedHost = secondaryResolvedHost;
    }
}

