/*
 * Decompiled with CFR 0.152.
 */
package com.imperva.ddc.core.query;

import com.imperva.ddc.core.Connector;
import com.imperva.ddc.core.query.CursorStatus;
import com.imperva.ddc.core.query.Endpoint;
import com.imperva.ddc.core.query.QueryResponse;
import java.util.ArrayList;
import java.util.List;

public class Cursor {
    private List<Endpoint> endpoints = new ArrayList<Endpoint>();
    private Connector connector;

    public Cursor(Connector connector) {
        this.connector = connector;
    }

    public List<Endpoint> getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(List<Endpoint> endpoints) {
        this.endpoints = endpoints;
    }

    public void addEndpoint(Endpoint endpoint) {
        this.endpoints.add(endpoint);
    }

    public void forgetPosition() {
        for (Endpoint endpoint : this.endpoints) {
            endpoint.hasNext(CursorStatus.STARTING);
        }
    }

    public QueryResponse next() {
        return this.connector.execute();
    }

    public boolean hasNext() {
        boolean hasNext = false;
        for (Endpoint endpoint : this.endpoints) {
            if (endpoint.hasNext() == CursorStatus.EOF) continue;
            return true;
        }
        return hasNext;
    }
}

