/*
 * Decompiled with CFR 0.152.
 */
package com.imperva.ddc.core.query;

import com.imperva.ddc.core.exceptions.BaseException;
import com.imperva.ddc.core.query.AddModificationDetails;
import com.imperva.ddc.core.query.DestinationType;
import com.imperva.ddc.core.query.Endpoint;
import com.imperva.ddc.core.query.Field;
import com.imperva.ddc.core.query.FieldType;
import com.imperva.ddc.core.query.ModificationDetails;
import com.imperva.ddc.core.query.RemoveModificationDetails;
import com.imperva.ddc.core.query.ReplaceModificationDetails;
import com.imperva.ddc.core.query.Request;
import java.util.ArrayList;
import java.util.List;

public class ChangeRequest
extends Request {
    private List<ModificationDetails> modificationDetailsList = new ArrayList<ModificationDetails>();
    private String dn;
    private Endpoint endpoint;

    public ChangeRequest(String dn) {
        this.dn = dn;
    }

    public ChangeRequest() {
    }

    public ChangeRequest add(String dn, FieldType fieldType, String value) {
        Field field = new Field();
        field.setType(fieldType);
        this.modificationDetailsList.add(new AddModificationDetails(dn, field, value));
        return this;
    }

    public ChangeRequest add(String dn, String fieldName, String value) {
        Field field = new Field();
        field.setName(fieldName);
        this.modificationDetailsList.add(new AddModificationDetails(dn, field, value));
        return this;
    }

    public ChangeRequest add(FieldType fieldType, String value) {
        this.checkDNExists();
        return this.add(this.dn, fieldType, value);
    }

    public ChangeRequest add(String fieldName, String value) {
        this.checkDNExists();
        return this.add(this.dn, fieldName, value);
    }

    public ChangeRequest remove(String dn, FieldType fieldType) {
        Field field = new Field();
        field.setType(fieldType);
        this.modificationDetailsList.add(new RemoveModificationDetails(dn, field));
        return this;
    }

    public ChangeRequest remove(String dn, String fieldName) {
        Field field = new Field();
        field.setName(fieldName);
        this.modificationDetailsList.add(new RemoveModificationDetails(dn, field));
        return this;
    }

    public ChangeRequest remove(FieldType fieldType) {
        this.checkDNExists();
        return this.remove(this.dn, fieldType);
    }

    public ChangeRequest remove(String fieldName) {
        this.checkDNExists();
        return this.remove(this.dn, fieldName);
    }

    public ChangeRequest remove(String dn, FieldType fieldType, Object value) {
        this.modificationDetailsList.add(new RemoveModificationDetails(dn, new Field(fieldType, value)));
        return this;
    }

    public ChangeRequest remove(FieldType fieldType, Object value) {
        this.checkDNExists();
        return this.remove(this.dn, fieldType, value);
    }

    public ChangeRequest replace(FieldType fieldType, String value) {
        this.checkDNExists();
        return this.replace(this.dn, fieldType, value);
    }

    public ChangeRequest replace(String dn, FieldType fieldType, String value) {
        Field field = new Field();
        field.setType(fieldType);
        this.modificationDetailsList.add(new ReplaceModificationDetails(dn, field, value));
        return this;
    }

    public ChangeRequest replace(String fieldName, String value) {
        this.checkDNExists();
        return this.replace(this.dn, fieldName, value);
    }

    public ChangeRequest replace(String dn, String fieldName, String value) {
        Field field = new Field();
        field.setName(fieldName);
        this.modificationDetailsList.add(new ReplaceModificationDetails(dn, field, value));
        return this;
    }

    private void checkDNExists() {
        if (this.dn == null || this.dn.isEmpty()) {
            throw new BaseException("DN is required. Either use the ChangeRequest(DN) constructor or specify the desired DN in the method itself.");
        }
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public List<ModificationDetails> getModificationDetailsList() {
        return this.modificationDetailsList;
    }

    public void setModificationDetailsList(List<ModificationDetails> modificationDetailsList) {
        this.modificationDetailsList = modificationDetailsList;
    }

    public String getDn() {
        return this.dn;
    }

    public void setDn(String dn) {
        this.dn = dn;
    }

    @Override
    public void close() {
        if (this.endpoint != null) {
            this.endpoint.close();
            this.endpoint.setLdapConnection(null);
            this.endpoint.setDestinationType(DestinationType.NONE);
        }
    }
}

