/*
 * Decompiled with CFR 0.152.
 */
package com.imperva.ddc.core;

import com.imperva.ddc.core.ApacheAPIConverter;
import com.imperva.ddc.core.Driver;
import com.imperva.ddc.core.DriverBase;
import com.imperva.ddc.core.DriverHostResolverDecorator;
import com.imperva.ddc.core.DriverRobustDecorator;
import com.imperva.ddc.core.commons.Utils;
import com.imperva.ddc.core.query.QueryRequest;
import com.imperva.ddc.core.query.QueryResponse;
import java.util.ArrayList;
import java.util.List;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.SearchCursor;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.message.Response;
import org.apache.directory.api.ldap.model.message.SearchResultEntry;
import org.apache.directory.api.ldap.model.message.SearchResultReference;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class QueryRequestExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)QueryRequestExecutor.class.getName());
    QueryRequest queryRequest;

    QueryRequestExecutor(QueryRequest queryRequest) {
        this.queryRequest = queryRequest;
    }

    List<Entry> run(SearchCursor cursor) {
        ArrayList<Entry> results = new ArrayList<Entry>();
        try {
            while (cursor.next()) {
                Response response = (Response)cursor.get();
                if (response instanceof SearchResultEntry) {
                    Entry entry = ((SearchResultEntry)response).getEntry();
                    results.add(entry);
                    continue;
                }
                if (!(response instanceof SearchResultReference)) continue;
            }
        }
        catch (LdapException e) {
            String error = "Can't execute LDAP request";
            LOGGER.error(error, (Object[])e.getStackTrace());
            throw new RuntimeException(error);
        }
        catch (CursorException e) {
            String error = "LDAP Cursor failed";
            LOGGER.error(error, (Object[])e.getStackTrace());
            throw new RuntimeException(error);
        }
        return results;
    }

    ApacheAPIConverter parserGetInstance() {
        return new ApacheAPIConverter();
    }

    String tryResolveBasePath(LdapConnection ldapConnection, String baseSearchPath) {
        if (!Utils.isEmpty(baseSearchPath)) {
            return baseSearchPath;
        }
        if (ldapConnection != null && ldapConnection.isConnected()) {
            try {
                Entry rootDSEInfo = ldapConnection.getRootDse(new String[]{"rootDomainNamingContext"});
                return rootDSEInfo.get("rootDomainNamingContext").getString();
            }
            catch (LdapException e) {
                LOGGER.error("Failed to resolve Base Path", (Throwable)e);
            }
        }
        return null;
    }

    DriverBase driverGetInstance() {
        return new DriverHostResolverDecorator(new DriverRobustDecorator(new Driver()));
    }

    abstract QueryResponse execute();
}

