/*
 * Decompiled with CFR 0.152.
 */
package com.imperva.ddc.core;

import com.imperva.ddc.core.AddRequestExecutor;
import com.imperva.ddc.core.ChangeRequestExecutor;
import com.imperva.ddc.core.Driver;
import com.imperva.ddc.core.DriverBase;
import com.imperva.ddc.core.DriverHostResolverDecorator;
import com.imperva.ddc.core.DriverRobustDecorator;
import com.imperva.ddc.core.QueryRequestExecutor;
import com.imperva.ddc.core.RemoveRequestExecutor;
import com.imperva.ddc.core.RequestExecutorFactory;
import com.imperva.ddc.core.query.AddRequest;
import com.imperva.ddc.core.query.ChangeRequest;
import com.imperva.ddc.core.query.ConnectionResponse;
import com.imperva.ddc.core.query.Endpoint;
import com.imperva.ddc.core.query.LdapConnectionResult;
import com.imperva.ddc.core.query.QueryRequest;
import com.imperva.ddc.core.query.QueryResponse;
import com.imperva.ddc.core.query.RemoveRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Executor {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)Executor.class.getName());

    Executor() {
    }

    QueryResponse execute(QueryRequest queryRequest) {
        QueryRequestExecutor queryRequestExecutor = this.queryRequestExecutorFactoryGetInstance().create(queryRequest);
        return queryRequestExecutor.execute();
    }

    void execute(ChangeRequest changeRequest) {
        ChangeRequestExecutor changeRequestExecutor = this.queryRequestExecutorFactoryGetInstance().create(changeRequest);
        changeRequestExecutor.execute();
    }

    void execute(RemoveRequest removeRequest) {
        RemoveRequestExecutor removeRequestExecutor = this.queryRequestExecutorFactoryGetInstance().create(removeRequest);
        removeRequestExecutor.execute();
    }

    void execute(AddRequest addRequest) {
        AddRequestExecutor addRequestExecutor = this.queryRequestExecutorFactoryGetInstance().create(addRequest);
        addRequestExecutor.execute();
    }

    ConnectionResponse testConnection(Endpoint endpoint) {
        String host = endpoint.getHost();
        DriverHostResolverDecorator driver = new DriverHostResolverDecorator(new DriverRobustDecorator(new Driver()));
        LOGGER.debug("Check connection: " + host);
        LdapConnectionResult ldapConnectionResult = ((DriverBase)driver).connect(endpoint);
        ConnectionResponse connectionResponse = new ConnectionResponse();
        connectionResponse.setStatuses(ldapConnectionResult.getStatuses());
        return connectionResponse;
    }

    RequestExecutorFactory queryRequestExecutorFactoryGetInstance() {
        return new RequestExecutorFactory();
    }
}

