/*
 * Decompiled with CFR 0.152.
 */
package com.imperva.ddc.core;

import com.imperva.ddc.core.DriverBase;
import com.imperva.ddc.core.exceptions.InvalidConnectionException;
import com.imperva.ddc.core.query.Endpoint;
import com.imperva.ddc.core.query.LdapConnectionResult;
import com.imperva.ddc.core.query.Status;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DriverRobustDecorator
extends DriverBase {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)DriverRobustDecorator.class.getName());
    private DriverBase driverBase;

    DriverRobustDecorator(DriverBase driverBase) {
        this.driverBase = driverBase;
    }

    @Override
    LdapConnectionResult connect(Endpoint endpoint) {
        LdapConnectionResult ldapConnectionResult = this.driverBase.connect(endpoint);
        boolean connectionSucceeded = endpoint.isConnectionSucceeded();
        if (connectionSucceeded) {
            return ldapConnectionResult;
        }
        return this.retry(ldapConnectionResult, endpoint);
    }

    private LdapConnectionResult retry(LdapConnectionResult ldapConnectionResult, Endpoint endpoint) {
        boolean isStatusInvalidConnection;
        int numOfRetries = 3;
        int retryCounter = new Integer(numOfRetries);
        Map<String, Status> status = ldapConnectionResult.getStatuses();
        Status primaryStatus = status.get(endpoint.getHost());
        Status secondaryStatus = status.get(endpoint.getSecondaryHost());
        Exception toCheck = primaryStatus != null && primaryStatus.isError() && primaryStatus.getError() instanceof InvalidConnectionException ? primaryStatus.getError() : (secondaryStatus != null && secondaryStatus.isError() && secondaryStatus.getError() instanceof InvalidConnectionException ? secondaryStatus.getError() : null);
        boolean bl = isStatusInvalidConnection = toCheck != null;
        while (!endpoint.isConnectionSucceeded() && isStatusInvalidConnection && retryCounter > 0) {
            LOGGER.debug("Retry connecting " + (numOfRetries - --retryCounter) + " / " + numOfRetries);
            try {
                Thread.sleep(5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ldapConnectionResult = this.driverBase.connect(endpoint);
        }
        return ldapConnectionResult;
    }
}

