/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.topic.message;

import com.icthh.xm.commons.lep.api.LepEngineSession;
import com.icthh.xm.commons.lep.api.LepManagementService;
import com.icthh.xm.commons.tenant.TenantContextHolder;
import com.icthh.xm.commons.tenant.TenantContextUtils;
import com.icthh.xm.commons.topic.domain.TopicConfig;
import com.icthh.xm.commons.topic.message.MessageHandler;
import com.icthh.xm.commons.topic.message.MessageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LepMessageHandler
implements MessageHandler {
    private static final Logger log = LoggerFactory.getLogger(LepMessageHandler.class);
    private final MessageService messageListenerService;
    private final TenantContextHolder tenantContextHolder;
    private final LepManagementService lepManagementService;

    @Override
    public void onMessage(String message, String tenant, TopicConfig topicConfig) {
        this.tenantContextHolder.getPrivilegedContext().execute(TenantContextUtils.buildTenant((String)tenant), () -> {
            try (LepEngineSession context = this.lepManagementService.beginThreadContext();){
                this.messageListenerService.onMessage(message, topicConfig);
            }
        });
    }

    public LepMessageHandler(MessageService messageListenerService, TenantContextHolder tenantContextHolder, LepManagementService lepManagementService) {
        this.messageListenerService = messageListenerService;
        this.tenantContextHolder = tenantContextHolder;
        this.lepManagementService = lepManagementService;
    }
}

