/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.topic.service;

import com.icthh.xm.commons.topic.config.AutoCreateTopicConfiguration;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.annotation.PostConstruct;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.KafkaFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"xm-commons.xm-topic.auto-create.enable"}, matchIfMissing=false, havingValue="true")
public class AutoCreateTopicService {
    private static final Logger log = LoggerFactory.getLogger(AutoCreateTopicService.class);
    private final KafkaProperties kafkaProperties;
    private final AutoCreateTopicConfiguration autoCreateTopicConfigs;

    @PostConstruct
    public void createTopics() {
        HashMap<String, List> configs = new HashMap<String, List>();
        configs.put("bootstrap.servers", this.kafkaProperties.getBootstrapServers());
        try (AdminClient client = AdminClient.create(configs);){
            ListTopicsOptions options = new ListTopicsOptions();
            options.listInternal(true);
            ListTopicsResult topics = client.listTopics(options);
            Set currentTopicList = (Set)topics.names().get();
            for (AutoCreateTopicConfiguration.AutoCreateTopicConfig config : this.autoCreateTopicConfigs.getConfig()) {
                if (currentTopicList.contains(config.getTopicName())) continue;
                log.info("Creating topic {}", (Object)config.getTopicName());
                NewTopic newTopic = new NewTopic(config.getTopicName(), config.getNumPartitions().intValue(), config.getReplicationFactor().shortValue());
                CreateTopicsResult result = client.createTopics(List.of(newTopic));
                ((KafkaFuture)result.values().get(config.getTopicName())).get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("Cannot create topics from config {}", (Object)this.autoCreateTopicConfigs, (Object)e);
        }
    }

    public AutoCreateTopicService(KafkaProperties kafkaProperties, AutoCreateTopicConfiguration autoCreateTopicConfigs) {
        this.kafkaProperties = kafkaProperties;
        this.autoCreateTopicConfigs = autoCreateTopicConfigs;
    }
}

