/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.topic.config;

import com.icthh.xm.commons.topic.domain.TopicConfig;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.FixedBackOffPolicy;
import org.springframework.retry.policy.AlwaysRetryPolicy;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.retry.support.RetryTemplate;

public class MessageRetryTemplate
extends RetryTemplate {
    public MessageRetryTemplate(TopicConfig topicConfig) {
        Integer retriesCount = topicConfig.getRetriesCount();
        if (retriesCount == null || retriesCount.equals(-1)) {
            super.setRetryPolicy((RetryPolicy)new AlwaysRetryPolicy());
        } else {
            super.setRetryPolicy((RetryPolicy)new SimpleRetryPolicy(retriesCount.intValue()));
        }
        Long backOffPeriod = topicConfig.getBackOffPeriod();
        FixedBackOffPolicy fixedBackOffPolicy = new FixedBackOffPolicy();
        if (backOffPeriod != null) {
            fixedBackOffPolicy.setBackOffPeriod(backOffPeriod.longValue());
        }
        super.setBackOffPolicy((BackOffPolicy)fixedBackOffPolicy);
    }
}

