/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.security.internal;

import io.jsonwebtoken.Claims;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class XmAuthenticationDetails {
    private final Long createTokenTime;
    private final String userName;
    private final Set<String> scope;
    private final String roleKey;
    private final String userKey;
    private final List<XmLogin> logins;
    private final Set<String> authorities;
    private final String clientId;
    private final String remoteAddress;
    private final String sessionId;
    private final String tokenValue;
    private final String tokenType;
    private final Map<String, Object> decodedDetails;

    public XmAuthenticationDetails(Claims claims, HttpServletRequest request, String token) {
        this.createTokenTime = (Long)claims.get("createTokenTime", Long.class);
        this.userName = (String)claims.get("user_name", String.class);
        this.roleKey = (String)claims.get("role_key", String.class);
        this.userKey = (String)claims.get("user_key", String.class);
        this.clientId = (String)claims.get("client_id", String.class);
        this.authorities = this.toSet((List)claims.get("authorities", List.class));
        this.scope = this.toSet((List)claims.get("scope", List.class));
        List logins = this.nullSafe((List)claims.get("logins", List.class));
        this.logins = logins.stream().map(it -> new XmLogin((String)it.get("typeKey"), (String)it.get("stateKey"), (String)it.get("login"))).toList();
        this.tokenValue = token;
        this.tokenType = "Bearer";
        this.remoteAddress = request.getRemoteAddr();
        HttpSession session = request.getSession(false);
        this.sessionId = session != null ? session.getId() : null;
        this.decodedDetails = Collections.unmodifiableMap(claims);
    }

    private Set<String> toSet(List<String> list) {
        return Collections.unmodifiableSet(new HashSet<String>(this.nullSafe(list)));
    }

    private <T> List<T> nullSafe(List<T> scope) {
        return scope == null ? Collections.emptyList() : scope;
    }

    public Long getCreateTokenTime() {
        return this.createTokenTime;
    }

    public String getUserName() {
        return this.userName;
    }

    public Set<String> getScope() {
        return this.scope;
    }

    public String getRoleKey() {
        return this.roleKey;
    }

    public String getUserKey() {
        return this.userKey;
    }

    public List<XmLogin> getLogins() {
        return this.logins;
    }

    public Set<String> getAuthorities() {
        return this.authorities;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getTokenValue() {
        return this.tokenValue;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public Map<String, Object> getDecodedDetails() {
        return this.decodedDetails;
    }

    public static class XmLogin {
        private final String typeKey;
        private final String stateKey;
        private final String login;

        public String getTypeKey() {
            return this.typeKey;
        }

        public String getStateKey() {
            return this.stateKey;
        }

        public String getLogin() {
            return this.login;
        }

        public XmLogin(String typeKey, String stateKey, String login) {
            this.typeKey = typeKey;
            this.stateKey = stateKey;
            this.login = login;
        }
    }
}

