/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.request.spring;

import com.icthh.xm.commons.request.XmPrivilegedRequestContext;
import com.icthh.xm.commons.request.XmRequestContextHolder;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class XmRequestContextInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmRequestContextInterceptor.class);
    private final XmRequestContextHolder requestContextHolder;
    private final String contextRequestSourceKey;
    private final Object requestSourceType;

    public XmRequestContextInterceptor(XmRequestContextHolder requestContextHolder, String contextRequestSourceKey, Object requestSourceType) {
        this.requestContextHolder = requestContextHolder;
        this.contextRequestSourceKey = contextRequestSourceKey;
        this.requestSourceType = requestSourceType;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        LOGGER.debug("Init XM request context for {} interceptor", this.requestSourceType);
        this.getXmPrivilegedRequestContext().putValue(this.contextRequestSourceKey, this.requestSourceType);
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        LOGGER.debug("Destroy XM request context");
        this.getXmPrivilegedRequestContext().destroyCurrentContext();
    }

    private XmPrivilegedRequestContext getXmPrivilegedRequestContext() {
        return this.requestContextHolder.getPrivilegedContext();
    }
}

