/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.web.spring.config;

import com.icthh.xm.commons.tenant.XmRelatedComponent;
import com.icthh.xm.commons.web.spring.TenantInterceptor;
import com.icthh.xm.commons.web.spring.XmLoggingInterceptor;
import com.icthh.xm.commons.web.spring.config.XmMsWebConfiguration;
import com.icthh.xm.commons.web.spring.config.XmWebMvcConfigurerAdapter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.servlet.AsyncHandlerInterceptor;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;

@Configuration
@Import(value={XmMsWebConfiguration.class})
public class WebMvcConfig
extends XmWebMvcConfigurerAdapter {
    private static final Logger log = LoggerFactory.getLogger(WebMvcConfig.class);
    private final List<String> tenantIgnoredPathList;
    private final ApplicationContext applicationContext;

    public WebMvcConfig(@Value(value="${application.tenant-ignored-path-list}") List<String> tenantIgnoredPathList, TenantInterceptor tenantInterceptor, XmLoggingInterceptor xmLoggingInterceptor, ApplicationContext applicationContext) {
        super(tenantInterceptor, xmLoggingInterceptor);
        this.applicationContext = applicationContext;
        this.tenantIgnoredPathList = tenantIgnoredPathList;
    }

    @Override
    protected void xmAddInterceptors(InterceptorRegistry registry) {
        this.applicationContext.getBeansWithAnnotation(XmRelatedComponent.class).values().stream().filter(it -> it instanceof AsyncHandlerInterceptor).map(it -> (AsyncHandlerInterceptor)it).forEach(interceptor -> this.registerTenantInterceptorWithIgnorePathPattern(registry, (HandlerInterceptor)interceptor));
    }

    @Override
    protected void xmConfigurePathMatch(PathMatchConfigurer configurer) {
    }

    @Override
    protected List<String> getTenantIgnorePathPatterns() {
        return this.tenantIgnoredPathList;
    }
}

