/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.web.spring;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.QueryParams;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.agent.AgentConsulClient;
import com.ecwid.consul.v1.catalog.model.CatalogService;
import java.util.List;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.discovery.event.InstancePreRegisteredEvent;
import org.springframework.cloud.client.serviceregistry.AbstractAutoServiceRegistration;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"gracefulShutdown.enabled"}, havingValue="true")
public class ShutdownListener
implements SmartLifecycle {
    private static final Logger log = LoggerFactory.getLogger(ShutdownListener.class);
    private final AbstractAutoServiceRegistration autoServiceRegistration;
    private final ConsulClient consulClient;
    private Registration registration;
    @Value(value="${spring.application.name}")
    private String appName;
    @Value(value="${gracefulShutdown.shutdownDelay}")
    private Long shutdownDelay;

    public void start() {
    }

    @EventListener(value={InstancePreRegisteredEvent.class})
    public void onRegister(InstancePreRegisteredEvent event) {
        this.registration = event.getRegistration();
    }

    public void stop() {
        StopWatch time = StopWatch.createStarted();
        log.info("START: shutdown process");
        this.autoServiceRegistration.stop();
        if (this.registration != null) {
            String instanceId = this.registration.getInstanceId();
            Response response = this.consulClient.getCatalogService(this.appName, QueryParams.DEFAULT);
            ((List)response.getValue()).stream().filter(service -> service.getServiceId().equals(instanceId)).forEach(this::deregister);
        }
        Thread.sleep(this.shutdownDelay);
        log.info("STOP: shutdown process, {}ms", (Object)time.getTime());
    }

    private void deregister(CatalogService it) {
        String instanceId = this.registration.getInstanceId();
        StopWatch time = StopWatch.createStarted();
        log.info("start deregistration {}", (Object)this.appName);
        new AgentConsulClient(it.getAddress()).agentServiceDeregister(instanceId);
        log.info("stop deregistration {}, {}ms", (Object)this.appName, (Object)time.getTime());
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public boolean isRunning() {
        return true;
    }

    public ShutdownListener(AbstractAutoServiceRegistration autoServiceRegistration, ConsulClient consulClient) {
        this.autoServiceRegistration = autoServiceRegistration;
        this.consulClient = consulClient;
    }
}

