/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.migration.db.config;

import com.icthh.xm.commons.migration.db.XmMultiTenantSpringLiquibase;
import com.icthh.xm.commons.migration.db.XmSpringLiquibase;
import com.icthh.xm.commons.migration.db.config.EntityScanPackageProvider;
import com.icthh.xm.commons.migration.db.tenant.SchemaResolver;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import liquibase.integration.spring.MultiTenantSpringLiquibase;
import liquibase.integration.spring.SpringLiquibase;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.MultiTenancyStrategy;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.hibernate.engine.jdbc.connections.spi.MultiTenantConnectionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseProperties;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;

@EnableTransactionManagement
public abstract class DatabaseConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DatabaseConfiguration.class);
    private static final String SPRING_PROFILE_NO_LIQUIBASE = "no-liquibase";
    private final Environment env;
    private final JpaProperties jpaProperties;
    private final SchemaResolver schemaResolver;

    public DatabaseConfiguration(Environment env, JpaProperties jpaProperties, SchemaResolver schemaResolver) {
        this.env = env;
        this.jpaProperties = jpaProperties;
        this.schemaResolver = schemaResolver;
    }

    @Bean
    public SpringLiquibase liquibase(DataSource dataSource, LiquibaseProperties liquibaseProperties) {
        this.schemaResolver.createSchemas(dataSource);
        XmSpringLiquibase liquibase = new XmSpringLiquibase();
        liquibase.setDataSource(dataSource);
        liquibase.setChangeLog("classpath:config/liquibase/master.xml");
        liquibase.setContexts(liquibaseProperties.getContexts());
        liquibase.setDefaultSchema(liquibaseProperties.getDefaultSchema());
        liquibase.setDropFirst(liquibaseProperties.isDropFirst());
        if (this.env.acceptsProfiles(Profiles.of((String[])new String[]{SPRING_PROFILE_NO_LIQUIBASE}))) {
            liquibase.setShouldRun(false);
        } else {
            liquibase.setShouldRun(liquibaseProperties.isEnabled());
            log.debug("Configuring Liquibase");
        }
        return liquibase;
    }

    @Bean
    @DependsOn(value={"liquibase"})
    public MultiTenantSpringLiquibase multiTenantLiquibase(DataSource dataSource, LiquibaseProperties liquibaseProperties) {
        XmMultiTenantSpringLiquibase liquibase = new XmMultiTenantSpringLiquibase();
        liquibase.setDataSource(dataSource);
        liquibase.setChangeLog("classpath:config/liquibase/master.xml");
        liquibase.setContexts(liquibaseProperties.getContexts());
        liquibase.setDefaultSchema(liquibaseProperties.getDefaultSchema());
        liquibase.setDropFirst(liquibaseProperties.isDropFirst());
        liquibase.setSchemas(this.schemaResolver.getSchemas());
        if (this.env.acceptsProfiles(Profiles.of((String[])new String[]{SPRING_PROFILE_NO_LIQUIBASE}))) {
            liquibase.setShouldRun(false);
        } else {
            liquibase.setShouldRun(liquibaseProperties.isEnabled());
            log.debug("Configuring Liquibase");
        }
        return liquibase;
    }

    @Bean
    public JpaVendorAdapter jpaVendorAdapter() {
        return new HibernateJpaVendorAdapter();
    }

    @Bean
    public LocalContainerEntityManagerFactoryBean entityManagerFactory(DataSource dataSource, MultiTenantConnectionProvider multiTenantConnectionProviderImpl, CurrentTenantIdentifierResolver currentTenantIdentifierResolverImpl, LocalValidatorFactoryBean localValidatorFactoryBean, List<EntityScanPackageProvider> entityScanPackageProviderList) {
        HashMap<String, Object> properties = new HashMap<String, Object>(this.jpaProperties.getProperties());
        properties.put("hibernate.multiTenancy", MultiTenancyStrategy.SCHEMA);
        properties.put("hibernate.multi_tenant_connection_provider", multiTenantConnectionProviderImpl);
        properties.put("hibernate.tenant_identifier_resolver", currentTenantIdentifierResolverImpl);
        properties.put("javax.persistence.validation.factory", localValidatorFactoryBean);
        LocalContainerEntityManagerFactoryBean em = new LocalContainerEntityManagerFactoryBean();
        em.setDataSource(dataSource);
        em.setPackagesToScan(this.getJpaPackages(entityScanPackageProviderList));
        em.setJpaVendorAdapter(this.jpaVendorAdapter());
        em.setJpaPropertyMap(properties);
        return em;
    }

    public abstract String getJpaPackages();

    private String[] getJpaPackages(List<EntityScanPackageProvider> entityScanPackageProviderList) {
        List packageList = entityScanPackageProviderList.stream().filter(it -> it != null && StringUtils.isNotBlank((CharSequence)it.getJpaPackages())).map(EntityScanPackageProvider::getJpaPackages).collect(Collectors.toList());
        String jpaPackage = this.getJpaPackages();
        if (StringUtils.isNotBlank((CharSequence)jpaPackage)) {
            packageList.add(jpaPackage);
        }
        return (String[])packageList.toArray(String[]::new);
    }
}

