/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.logging.util;

import java.util.Map;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class BasePackageDetector {
    private static final String XM_BASE_PACKAGE = "com.icthh.xm";
    private final String basePackage;

    public BasePackageDetector(ApplicationContext context) {
        Map candidates = context.getBeansWithAnnotation(SpringBootApplication.class);
        this.basePackage = candidates.isEmpty() ? XM_BASE_PACKAGE : this.toPackageName(candidates);
    }

    private String toPackageName(Map<String, Object> candidates) {
        String packageName = candidates.values().toArray()[0].getClass().getPackageName();
        if (packageName.indexOf(".ms.") > 0) {
            return packageName.substring(0, packageName.indexOf(".ms."));
        }
        return packageName;
    }

    public String getBasePackage() {
        return this.basePackage;
    }
}

