/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.logging.util;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.MDC;

public final class MdcUtils {
    private static final int RID_LENGTH = 8;
    private static final String RID = "rid";
    private static final String TIME = "time";

    private MdcUtils() {
        throw new IllegalAccessError("Access not allowed");
    }

    public static void putRid() {
        MdcUtils.put(RID);
    }

    public static void putRid(String ridValue) {
        MdcUtils.put(RID, ridValue);
    }

    public static void put(String key) {
        MdcUtils.put(key, MdcUtils.generateRid());
    }

    public static void put(String key, String value) {
        MDC.put((String)key, (String)(value == null ? MdcUtils.generateRid() : value));
        MDC.put((String)(key + TIME), (String)String.valueOf(System.nanoTime()));
    }

    public static String getRid() {
        return MDC.get((String)RID);
    }

    public static void removeRid() {
        MdcUtils.remove(RID);
    }

    public static void remove(String key) {
        MDC.remove((String)key);
        MDC.remove((String)(key + TIME));
    }

    public static long getRidTimeNs() {
        return MdcUtils.getTimeNs(RID);
    }

    public static long getTimeNs(String key) {
        String time = MDC.get((String)(key + TIME));
        return StringUtils.isNotBlank((CharSequence)time) ? Long.parseLong(time) : 0L;
    }

    public static long getExecTimeMs() {
        return MdcUtils.getExecTimeMs(RID);
    }

    public static long getExecTimeMs(String key) {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - MdcUtils.getTimeNs(key));
    }

    public static void clear() {
        MDC.clear();
    }

    public static String generateRid() {
        byte[] encode = Base64.getEncoder().encode(DigestUtils.sha256((String)UUID.randomUUID().toString()));
        try {
            String rid = new String(encode, StandardCharsets.UTF_8.name());
            rid = StringUtils.replaceChars((String)rid, (String)"+/=", (String)"");
            return StringUtils.right((String)rid, (int)8);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }
}

