/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.logging.web.util;

import com.icthh.xm.commons.logging.util.LogObjectPrinter;
import org.aspectj.lang.JoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public final class WebLogObjectPrinter {
    private static final Logger log = LoggerFactory.getLogger(WebLogObjectPrinter.class);

    public static RestResp printRestResult(JoinPoint joinPoint, Object res) {
        return WebLogObjectPrinter.printRestResult(joinPoint, res, true);
    }

    public static RestResp printRestResult(JoinPoint joinPoint, Object res, boolean printBody) {
        String bodyToPrint;
        String status;
        if (res == null) {
            return new RestResp("OK", "null", printBody);
        }
        Class<?> respClass = res.getClass();
        if (ResponseEntity.class.isAssignableFrom(respClass)) {
            ResponseEntity respEn = (ResponseEntity)ResponseEntity.class.cast(res);
            status = String.valueOf(respEn.getStatusCode());
            Object body = respEn.getBody();
            bodyToPrint = LogObjectPrinter.printResult((JoinPoint)joinPoint, (Object)body, (boolean)printBody);
        } else {
            status = "OK";
            bodyToPrint = LogObjectPrinter.printResult((JoinPoint)joinPoint, (Object)res, (boolean)printBody);
        }
        return new RestResp(status, bodyToPrint, printBody);
    }

    private WebLogObjectPrinter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class RestResp {
        private String status;
        private Object bodyToPrint;
        private boolean printBody;

        public String toString() {
            return "status=" + this.status + ", body=" + this.bodyToPrint;
        }

        public RestResp(String status, Object bodyToPrint, boolean printBody) {
            this.status = status;
            this.bodyToPrint = bodyToPrint;
            this.printBody = printBody;
        }

        public String getStatus() {
            return this.status;
        }

        public Object getBodyToPrint() {
            return this.bodyToPrint;
        }

        public boolean isPrintBody() {
            return this.printBody;
        }
    }
}

