/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.logging.web.aop;

import com.icthh.xm.commons.logging.util.LogObjectPrinter;
import com.icthh.xm.commons.logging.util.MdcUtils;
import com.icthh.xm.commons.logging.web.util.WebLogObjectPrinter;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Aspect
public class RestLoggingAspect {
    private static final Logger log = LoggerFactory.getLogger(RestLoggingAspect.class);

    @Pointcut(value="within(com.icthh.xm..*)")
    public void restPackagePointcut() {
    }

    @Pointcut(value="restPackagePointcut() && @target(controllerMapping) && @annotation(methodMapping)")
    public void restControllerGetPointcut(RequestMapping controllerMapping, GetMapping methodMapping) {
    }

    @Pointcut(value="restPackagePointcut() && @target(controllerMapping) && @annotation(methodMapping)")
    public void restControllerPostPointcut(RequestMapping controllerMapping, PostMapping methodMapping) {
    }

    @Pointcut(value="restPackagePointcut() && @target(controllerMapping) && @annotation(methodMapping)")
    public void restControllerPutPointcut(RequestMapping controllerMapping, PutMapping methodMapping) {
    }

    @Pointcut(value="restPackagePointcut() && @target(controllerMapping) && @annotation(methodMapping)")
    public void restControllerDeletePointcut(RequestMapping controllerMapping, DeleteMapping methodMapping) {
    }

    @Before(value="restControllerGetPointcut(controllerMapping, methodMapping)")
    public void logBeforeRest(JoinPoint joinPoint, RequestMapping controllerMapping, GetMapping methodMapping) {
        this.logStart(joinPoint, HttpMethod.GET, controllerMapping.value(), methodMapping.value());
    }

    @Before(value="restControllerPostPointcut(controllerMapping, methodMapping)")
    public void logBeforeRest(JoinPoint joinPoint, RequestMapping controllerMapping, PostMapping methodMapping) {
        this.logStart(joinPoint, HttpMethod.POST, controllerMapping.value(), methodMapping.value());
    }

    @Before(value="restControllerPutPointcut(controllerMapping, methodMapping)")
    public void logBeforeRest(JoinPoint joinPoint, RequestMapping controllerMapping, PutMapping methodMapping) {
        this.logStart(joinPoint, HttpMethod.PUT, controllerMapping.value(), methodMapping.value());
    }

    @Before(value="restControllerDeletePointcut(controllerMapping, methodMapping)")
    public void logBeforeRest(JoinPoint joinPoint, RequestMapping controllerMapping, DeleteMapping methodMapping) {
        this.logStart(joinPoint, HttpMethod.DELETE, controllerMapping.value(), methodMapping.value());
    }

    @AfterReturning(value="restControllerGetPointcut(controllerMapping, methodMapping)", returning="result")
    public void logAfterRest(JoinPoint joinPoint, RequestMapping controllerMapping, GetMapping methodMapping, Object result) {
        this.logStop(joinPoint, HttpMethod.GET, controllerMapping.value(), methodMapping.value(), result);
    }

    @AfterReturning(value="restControllerPostPointcut(controllerMapping, methodMapping)", returning="result")
    public void logAfterRest(JoinPoint joinPoint, RequestMapping controllerMapping, PostMapping methodMapping, Object result) {
        this.logStop(joinPoint, HttpMethod.POST, controllerMapping.value(), methodMapping.value(), result);
    }

    @AfterReturning(value="restControllerPutPointcut(controllerMapping, methodMapping)", returning="result")
    public void logAfterRest(JoinPoint joinPoint, RequestMapping controllerMapping, PutMapping methodMapping, Object result) {
        this.logStop(joinPoint, HttpMethod.PUT, controllerMapping.value(), methodMapping.value(), result);
    }

    @AfterReturning(value="restControllerDeletePointcut(controllerMapping, methodMapping)", returning="result")
    public void logAfterRest(JoinPoint joinPoint, RequestMapping controllerMapping, DeleteMapping methodMapping, Object result) {
        this.logStop(joinPoint, HttpMethod.DELETE, controllerMapping.value(), methodMapping.value(), result);
    }

    @AfterThrowing(value="restControllerGetPointcut(controllerMapping, methodMapping)", throwing="e")
    public void logAfterRestThrowing(JoinPoint joinPoint, RequestMapping controllerMapping, GetMapping methodMapping, Throwable e) {
        this.logError(joinPoint, HttpMethod.GET, controllerMapping.value(), methodMapping.value(), e);
    }

    @AfterThrowing(value="restControllerPostPointcut(controllerMapping, methodMapping)", throwing="e")
    public void logAfterRestThrowing(JoinPoint joinPoint, RequestMapping controllerMapping, PostMapping methodMapping, Throwable e) {
        this.logError(joinPoint, HttpMethod.POST, controllerMapping.value(), methodMapping.value(), e);
    }

    @AfterThrowing(value="restControllerPutPointcut(controllerMapping, methodMapping)", throwing="e")
    public void logAfterRestThrowing(JoinPoint joinPoint, RequestMapping controllerMapping, PutMapping methodMapping, Throwable e) {
        this.logError(joinPoint, HttpMethod.PUT, controllerMapping.value(), methodMapping.value(), e);
    }

    @AfterThrowing(value="restControllerDeletePointcut(controllerMapping, methodMapping)", throwing="e")
    public void logAfterRestThrowing(JoinPoint joinPoint, RequestMapping controllerMapping, DeleteMapping methodMapping, Throwable e) {
        this.logError(joinPoint, HttpMethod.DELETE, controllerMapping.value(), methodMapping.value(), e);
    }

    private void logStart(JoinPoint joinPoint, HttpMethod method, String[] controllerPath, String[] methodPath) {
        log.info("START {} : {} --> {}, input: {}", new Object[]{method, LogObjectPrinter.joinUrlPaths((Object[])controllerPath, (Object[])methodPath), LogObjectPrinter.getCallMethod((JoinPoint)joinPoint), LogObjectPrinter.printInputParams((JoinPoint)joinPoint, (String[])new String[0])});
    }

    private void logStop(JoinPoint joinPoint, HttpMethod method, String[] controllerPath, String[] methodPath, Object result) {
        log.info("STOP  {} : {} --> {}, result: {}, time = {} ms", new Object[]{method, LogObjectPrinter.joinUrlPaths((Object[])controllerPath, (Object[])methodPath), LogObjectPrinter.getCallMethod((JoinPoint)joinPoint), WebLogObjectPrinter.printRestResult(joinPoint, result), MdcUtils.getExecTimeMs()});
    }

    private void logError(JoinPoint joinPoint, HttpMethod method, String[] controllerPath, String[] methodPath, Throwable e) {
        log.error("STOP  {} : {} --> {}, error: {}, time = {} ms", new Object[]{method, LogObjectPrinter.joinUrlPaths((Object[])controllerPath, (Object[])methodPath), LogObjectPrinter.getCallMethod((JoinPoint)joinPoint), LogObjectPrinter.printExceptionWithStackInfo((Throwable)e), MdcUtils.getExecTimeMs()});
    }
}

