/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.icthh.xm.commons.config.FunctionApiSpecConfiguration;
import com.icthh.xm.commons.config.client.repository.CommonConfigRepository;
import com.icthh.xm.commons.config.client.service.CommonConfigService;
import com.icthh.xm.commons.config.domain.Configuration;
import com.icthh.xm.commons.domain.FunctionSpecWithFileName;
import com.icthh.xm.commons.domain.spec.FunctionSpec;
import com.icthh.xm.commons.exceptions.BusinessException;
import com.icthh.xm.commons.exceptions.EntityNotFoundException;
import com.icthh.xm.commons.service.FunctionManageService;
import com.icthh.xm.commons.tenant.TenantContextHolder;
import com.icthh.xm.commons.utils.YamlPatchUtils;
import io.micrometer.common.util.StringUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionManageServiceImpl
implements FunctionManageService<FunctionSpec, FunctionSpecWithFileName<FunctionSpec>> {
    private static final Logger log = LoggerFactory.getLogger(FunctionManageServiceImpl.class);
    private final FunctionApiSpecConfiguration specService;
    private final TenantContextHolder tenantContextHolder;
    private final CommonConfigRepository commonConfigRepository;
    private final CommonConfigService commonConfigService;

    @Override
    public void addFunction(FunctionSpecWithFileName<FunctionSpec> newFunction) {
        this.assertKeyUnique(newFunction);
        Configuration configuration = this.findOriginalConfig(newFunction.getFileKey());
        String yamlFile = configuration.getContent();
        if (StringUtils.isBlank((String)yamlFile)) {
            yamlFile = "functions:\n";
        }
        FunctionSpec item = newFunction.getItem();
        String updatedYaml = YamlPatchUtils.addSequenceItem(yamlFile, item, this.addPath());
        Configuration updatedConfig = new Configuration(configuration.getPath(), updatedYaml);
        this.commonConfigRepository.updateConfigFullPath(updatedConfig, null);
        this.commonConfigService.notifyUpdated(updatedConfig);
    }

    protected List<YamlPatchUtils.YamlPatchPattern> addPath() {
        return List.of(YamlPatchUtils.key("functions"));
    }

    protected List<YamlPatchUtils.YamlPatchPattern> removePath(String functionKey) {
        return List.of(YamlPatchUtils.key("functions"), YamlPatchUtils.arrayByField(Map.of("key", functionKey)));
    }

    private void assertKeyUnique(FunctionSpecWithFileName<FunctionSpec> newFunction) {
        this.specService.getSpecByKeyAndTenant(newFunction.getItem().getKey(), this.tenantContextHolder.getTenantKey()).ifPresent(spec -> {
            log.error("Function with key '{}' already exists", (Object)((FunctionSpec)newFunction.getItem()).getKey());
            throw new BusinessException("error.function.with.key.already.exists", "Function already exists");
        });
    }

    private void assertKeyExists(FunctionSpecWithFileName<FunctionSpec> updatedFunction) {
        this.specService.getSpecByKeyAndTenant(updatedFunction.getItem().getKey(), this.tenantContextHolder.getTenantKey()).orElseThrow(() -> FunctionManageServiceImpl.throwFunctionNotFound(((FunctionSpec)updatedFunction.getItem()).getKey()));
    }

    private static BusinessException throwFunctionNotFound(String functionKey) {
        log.error("Function with key '{}' not exists", (Object)functionKey);
        return new BusinessException("error.function.with.key.not.exists", "Function not exists");
    }

    @Override
    public void updateFunction(FunctionSpecWithFileName<FunctionSpec> updatedFunction) {
        this.assertKeyExists(updatedFunction);
        String functionKey = updatedFunction.getItem().getKey();
        String oldFileKey = this.getFileKeyByFunctionKey(functionKey);
        if (Objects.equals(oldFileKey, updatedFunction.getFileKey())) {
            Configuration originalConfig = this.findOriginalConfig(oldFileKey);
            String updatedYaml = YamlPatchUtils.updateSequenceItem(originalConfig.getContent(), updatedFunction.getItem(), this.removePath(functionKey));
            Configuration updatedConfig = new Configuration(originalConfig.getPath(), updatedYaml);
            this.commonConfigRepository.updateConfigFullPath(updatedConfig, null);
            this.commonConfigService.notifyUpdated(updatedConfig);
        } else {
            this.removeFunction(functionKey);
            this.addFunction(updatedFunction);
        }
    }

    @Override
    public void removeFunction(String functionKey) {
        String fileKey = this.getFileKeyByFunctionKey(functionKey);
        Configuration configuration = this.findOriginalConfig(fileKey);
        if (configuration.getContent() == null) {
            throw new EntityNotFoundException("Function not found, fileKey: " + fileKey + ", functionKey: " + functionKey);
        }
        String updatedYaml = YamlPatchUtils.delete(configuration.getContent(), this.removePath(functionKey));
        Configuration updatedConfig = new Configuration(configuration.getPath(), updatedYaml);
        this.commonConfigRepository.updateConfigFullPath(updatedConfig, null);
        this.commonConfigService.notifyUpdated(updatedConfig);
    }

    @Override
    public TypeReference<FunctionSpecWithFileName<FunctionSpec>> getFunctionSpecWrapperClass() {
        return new TypeReference<FunctionSpecWithFileName<FunctionSpec>>(this){};
    }

    @Override
    public TypeReference<FunctionSpec> getFunctionSpecClass() {
        return new TypeReference<FunctionSpec>(this){};
    }

    protected Configuration findOriginalConfig(String fileKey) {
        String tenantKey = this.tenantContextHolder.getTenantKey();
        Map specFiles = this.specService.getSpecFiles(tenantKey);
        String filePath = this.buildFilePath(fileKey, tenantKey);
        String yamlFile = (String)specFiles.get(filePath);
        return new Configuration(filePath, yamlFile);
    }

    protected String buildFilePath(String fileKey, String tenantKey) {
        String folder = this.specService.getSpecFolder(tenantKey);
        return fileKey == null ? folder + ".yml" : folder + "/" + fileKey + ".yml";
    }

    protected String getFileKeyByFunctionKey(String functionKey) {
        String tenantKey = this.tenantContextHolder.getTenantKey();
        FunctionSpecWithFileName spec = this.specService.getFunctionSpecsWithFileName(tenantKey).stream().filter(e -> Objects.nonNull(e.getItem())).filter(e -> Objects.equals(((FunctionSpec)e.getItem()).getKey(), functionKey)).findFirst().orElseThrow(() -> FunctionManageServiceImpl.throwFunctionNotFound(functionKey));
        return spec.getFileKey();
    }

    public FunctionManageServiceImpl(FunctionApiSpecConfiguration specService, TenantContextHolder tenantContextHolder, CommonConfigRepository commonConfigRepository, CommonConfigService commonConfigService) {
        this.specService = specService;
        this.tenantContextHolder = tenantContextHolder;
        this.commonConfigRepository = commonConfigRepository;
        this.commonConfigService = commonConfigService;
    }
}

