/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.icthh.xm.commons.domain.FunctionResult;
import jakarta.persistence.Transient;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.springframework.web.servlet.ModelAndView;

public class DefaultFunctionResult
implements FunctionResult {
    private long executeTime;
    private Object data;
    @JsonIgnore
    @Transient
    private transient Boolean wrapResult;

    public DefaultFunctionResult(Object data, Boolean wrapResult) {
        this.data = data;
        this.wrapResult = wrapResult;
    }

    public DefaultFunctionResult(Object data) {
        this.data = data;
    }

    @Override
    @JsonIgnore
    public Object functionResult() {
        if (Boolean.TRUE.equals(this.wrapResult)) {
            return this;
        }
        return this.data;
    }

    @Override
    @JsonIgnore
    public ModelAndView getModelAndView() {
        return Optional.ofNullable(this.getData()).flatMap(this.isInstanceOf(Map.class)).map(d -> d.get("modelAndView")).orElse(null);
    }

    private <T> Function<Object, Optional<T>> isInstanceOf(Class<T> type) {
        return obj -> type.isInstance(obj) ? Optional.of(obj) : Optional.empty();
    }

    @Override
    public long getExecuteTime() {
        return this.executeTime;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    public Boolean getWrapResult() {
        return this.wrapResult;
    }

    @Override
    public void setExecuteTime(long executeTime) {
        this.executeTime = executeTime;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultFunctionResult)) {
            return false;
        }
        DefaultFunctionResult other = (DefaultFunctionResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getExecuteTime() != other.getExecuteTime()) {
            return false;
        }
        Object this$data = this.getData();
        Object other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultFunctionResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $executeTime = this.getExecuteTime();
        result = result * 59 + (int)($executeTime >>> 32 ^ $executeTime);
        Object $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "DefaultFunctionResult(executeTime=" + this.getExecuteTime() + ", data=" + String.valueOf(this.getData()) + ", wrapResult=" + this.getWrapResult() + ")";
    }

    public DefaultFunctionResult() {
    }

    @JsonIgnore
    public void setWrapResult(Boolean wrapResult) {
        this.wrapResult = wrapResult;
    }
}

