/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.service.impl;

import com.icthh.xm.commons.domain.enums.FunctionFeatureContext;
import com.icthh.xm.commons.domain.spec.IFunctionSpec;
import com.icthh.xm.commons.permission.domain.enums.IFeatureContext;
import com.icthh.xm.commons.permission.service.DynamicPermissionCheckService;
import com.icthh.xm.commons.service.FunctionService;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;

public abstract class AbstractFunctionService<FS extends IFunctionSpec>
implements FunctionService<FS> {
    private static final Logger log = LoggerFactory.getLogger(AbstractFunctionService.class);
    private final DynamicPermissionCheckService dynamicPermissionCheckService;
    private final AntPathMatcher matcher;

    protected AbstractFunctionService(DynamicPermissionCheckService dynamicPermissionCheckService) {
        this.dynamicPermissionCheckService = dynamicPermissionCheckService;
        this.matcher = new AntPathMatcher();
    }

    @Override
    public void validateFunctionKey(String functionKey) {
        Objects.requireNonNull(functionKey, "functionKey can't be null");
    }

    @Override
    public void checkPermissions(IFeatureContext featureContext, String basePermission, String functionKey) {
        this.dynamicPermissionCheckService.checkContextPermission(featureContext, basePermission, functionKey);
    }

    @Override
    public void checkPermissions(String basePermission, String functionKey) {
        this.checkPermissions(FunctionFeatureContext.FUNCTION, basePermission, functionKey);
    }

    @Override
    public void enrichInputFromPathParams(String functionKey, Map<String, Object> functionInput, FS functionSpec) {
        if (functionSpec.getPath() != null && this.matcher.match(functionSpec.getPath(), functionKey)) {
            functionInput.putAll(this.matcher.extractUriTemplateVariables(functionSpec.getPath(), functionKey));
        }
    }
}

