/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.web.rest;

import com.codahale.metrics.annotation.Timed;
import com.icthh.xm.commons.logging.aop.IgnoreLogginAspect;
import com.icthh.xm.commons.permission.annotation.PrivilegeDescription;
import com.icthh.xm.commons.service.FunctionExportServiceFacade;
import com.icthh.xm.commons.util.HeaderUtil;
import com.icthh.xm.commons.utils.HttpRequestUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class FunctionExportResource {
    private static final Logger log = LoggerFactory.getLogger(FunctionExportResource.class);
    private final FunctionExportServiceFacade functionExportService;
    private FunctionExportResource self;

    @Autowired
    public void setSelf(@Lazy FunctionExportResource self) {
        this.self = self;
    }

    @Timed
    @GetMapping(value={"/export/functions/{functionKey:.+}"})
    @PreAuthorize(value="hasPermission({'functionKey': #functionKey}, 'FUNCTION.EXPORT.CALL')")
    @PrivilegeDescription(value="Privilege to execute an export function by key")
    public ResponseEntity<Void> callExportFunction(@PathVariable(value="functionKey") String functionKey, @RequestParam String fileName, @RequestParam String fileFormat, @RequestParam(required=false) Map<String, Object> functionInput, HttpServletResponse response) {
        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "." + fileFormat + "\"");
        response.setContentType(HeaderUtil.getContentType(fileFormat));
        this.functionExportService.execute(functionKey, fileFormat, functionInput, response);
        return ResponseEntity.ok().build();
    }

    @IgnoreLogginAspect
    @Timed
    @GetMapping(value={"/export/functions/**"})
    @PreAuthorize(value="hasPermission({'functionKey': #functionKey}, 'FUNCTION.EXPORT.CALL')")
    @PrivilegeDescription(value="Privilege to execute an export function by key")
    public ResponseEntity<Void> getCallExportFunction(HttpServletRequest request, @RequestParam String fileName, @RequestParam String fileFormat, @RequestParam(required=false) Map<String, Object> functionInput, HttpServletResponse response) {
        String functionKey = HttpRequestUtils.getFunctionKey((HttpServletRequest)request);
        return this.self.callExportFunction(functionKey, fileName, fileFormat, functionInput, response);
    }

    public FunctionExportResource(FunctionExportServiceFacade functionExportService) {
        this.functionExportService = functionExportService;
    }
}

