/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.service.exporter;

import com.icthh.xm.commons.domain.BaseRow;
import com.icthh.xm.commons.service.FunctionExecutorService;
import com.icthh.xm.commons.service.exporter.AbstractExportServiceImpl;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Component;

@Component
public class XlsxExportService<T extends BaseRow>
extends AbstractExportServiceImpl<T> {
    private static final Logger log = LoggerFactory.getLogger(XlsxExportService.class);
    private static final String SHEET_NAME = "Report";

    protected XlsxExportService(FunctionExecutorService functionExecutorService) {
        super(functionExecutorService);
    }

    @Override
    public boolean supports(String fileFormat) {
        return Set.of("xlsx", "xls").contains(fileFormat);
    }

    @Override
    public void export(String functionKey, String fileFormat, Map<String, Object> functionInput, HttpServletResponse response) {
        int page = 0;
        long rowIndex = 0L;
        Page result = this.getNextPage(page, functionKey, functionInput);
        try (SXSSFWorkbook workbook = new SXSSFWorkbook(100);
             ServletOutputStream os = response.getOutputStream();){
            SXSSFSheet sheet = workbook.createSheet(SHEET_NAME);
            this.writeHeaderRow((Sheet)sheet, result.getContent());
            ++rowIndex;
            while (true) {
                rowIndex = this.writeDataRows((Sheet)sheet, result.getContent(), rowIndex);
                if (!result.hasNext()) break;
                result = this.getNextPage(++page, functionKey, functionInput);
            }
            workbook.write((OutputStream)os);
            os.flush();
        }
        catch (IOException e) {
            log.error("Exception while exporting data to xlsx file, {}", (Object)e.getMessage());
            throw new IllegalStateException("Exception while exporting data to xlsx file", e);
        }
    }

    private void writeHeaderRow(Sheet sheet, List<T> firstRow) {
        List headers = Optional.ofNullable(firstRow).filter(data -> !data.isEmpty()).map(d -> ((BaseRow)d.getFirst()).getHeaders()).orElse(List.of());
        this.fillRow(sheet.createRow(0), headers);
    }

    private long writeDataRows(Sheet sheet, List<T> rows, long startIndex) {
        long rowIndex = startIndex;
        for (BaseRow item : rows) {
            Row row = sheet.createRow((int)rowIndex++);
            this.fillRow(row, item.getFieldValues());
        }
        return rowIndex;
    }

    private void fillRow(Row row, List<?> rowValues) {
        IntStream.range(0, rowValues.size()).forEach(index -> {
            String value = Optional.ofNullable(rowValues.get(index)).map(Object::toString).orElse("");
            row.createCell(index).setCellValue(value);
        });
    }
}

