/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.exceptions.spring.web;

import com.icthh.xm.commons.exceptions.BusinessException;
import com.icthh.xm.commons.exceptions.EntityNotFoundException;
import com.icthh.xm.commons.exceptions.NoContentException;
import com.icthh.xm.commons.exceptions.SkipPermissionException;
import com.icthh.xm.commons.exceptions.domain.vm.ErrorVM;
import com.icthh.xm.commons.exceptions.domain.vm.FieldErrorVM;
import com.icthh.xm.commons.exceptions.domain.vm.ParameterizedErrorVM;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.client.HttpServerErrorException;

@ControllerAdvice
public class ExceptionTranslator {
    private static final Logger log = LoggerFactory.getLogger(ExceptionTranslator.class);
    private static final String ERROR_PREFIX = "error.";
    @Autowired
    private MessageSource messageSource;

    @ExceptionHandler(value={ConcurrencyFailureException.class})
    @ResponseStatus(value=HttpStatus.CONFLICT)
    @ResponseBody
    public ErrorVM processConcurrencyError(ConcurrencyFailureException ex) {
        log.debug("Concurrency failure", (Throwable)ex);
        return new ErrorVM("error.concurrencyFailure", this.translate("error.concurrencyFailure"));
    }

    @ExceptionHandler(value={SkipPermissionException.class})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public ResponseEntity<Void> processSkipException(SkipPermissionException ex) {
        log.debug("Skip permission {}", (Object)ex.getPermission());
        return ResponseEntity.ok().build();
    }

    @ExceptionHandler(value={NoContentException.class})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public FieldErrorVM processConcurrencyError(NoContentException ex) {
        log.debug("No content", (Throwable)ex);
        return new FieldErrorVM("error.nocontent", this.translate("error.nocontent"));
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public FieldErrorVM processMissingServletRequestParameterError(MissingServletRequestParameterException ex) {
        FieldErrorVM dto = new FieldErrorVM("error.validation", this.translate("error.validation"));
        dto.add(ex.getParameterType(), ex.getParameterName(), ex.getLocalizedMessage());
        return dto;
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public ErrorVM processValidationError(MethodArgumentNotValidException ex) {
        BindingResult result = ex.getBindingResult();
        List fieldErrors = result.getFieldErrors();
        FieldErrorVM dto = new FieldErrorVM("error.validation", this.translate("error.validation"));
        for (FieldError fieldError : fieldErrors) {
            dto.add(fieldError.getObjectName(), fieldError.getField(), fieldError.getCode());
        }
        return dto;
    }

    @ExceptionHandler(value={HttpServerErrorException.class})
    @ResponseBody
    public ResponseEntity<ErrorVM> processHttpServerError(HttpServerErrorException ex) {
        ErrorVM fieldErrorVM;
        ResponseEntity.BodyBuilder builder;
        HttpStatus responseStatus = ex.getStatusCode();
        if (responseStatus != null) {
            builder = ResponseEntity.status((int)responseStatus.value());
            fieldErrorVM = new ErrorVM(ERROR_PREFIX + responseStatus.value(), this.translate(ERROR_PREFIX + responseStatus.value()));
        } else {
            builder = ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR);
            fieldErrorVM = new ErrorVM("error.internalServerError", this.translate("error.internalServerError"));
        }
        return builder.body((Object)fieldErrorVM);
    }

    @ExceptionHandler(value={BusinessException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public ParameterizedErrorVM processParameterizedValidationError(BusinessException ex) {
        return new ParameterizedErrorVM(ex.getCode() == null ? "error.business" : ex.getCode(), ex.getMessage() != null ? ex.getMessage() : this.translate(ex.getCode()), ex.getParamMap());
    }

    @ExceptionHandler(value={EntityNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ResponseBody
    public ErrorVM processNotFoundError(EntityNotFoundException ex) {
        log.debug("Entity not found", (Throwable)ex);
        return new ErrorVM("error.notfound", this.translate("error.notfound"));
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public ErrorVM processAccessDeniedException(AccessDeniedException e) {
        log.debug("Access denied", (Throwable)e);
        return new ErrorVM("error.accessDenied", this.translate("error.accessDenied"));
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.METHOD_NOT_ALLOWED)
    public ErrorVM processMethodNotSupportedException(HttpRequestMethodNotSupportedException exception) {
        log.debug("Method not supported", (Throwable)exception);
        return new ErrorVM("error.methodNotSupported", this.translate("error.methodNotSupported"));
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<ErrorVM> processException(Exception ex) {
        ErrorVM errorVM;
        ResponseEntity.BodyBuilder builder;
        log.error("An unexpected error occurred: {}", (Object)ex.getMessage(), (Object)ex);
        ResponseStatus responseStatus = (ResponseStatus)AnnotationUtils.findAnnotation(ex.getClass(), ResponseStatus.class);
        if (responseStatus != null) {
            builder = ResponseEntity.status((HttpStatus)responseStatus.value());
            errorVM = new ErrorVM(ERROR_PREFIX + responseStatus.value().value(), this.translate(ERROR_PREFIX + responseStatus.value().value()));
        } else {
            builder = ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR);
            errorVM = new ErrorVM("error.internalServerError", this.translate("error.internalServerError"));
        }
        return builder.body((Object)errorVM);
    }

    private String translate(String code) {
        return this.messageSource.getMessage(code, null, LocaleContextHolder.getLocale());
    }
}

