/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.cache.config;

import com.github.benmanes.caffeine.cache.Ticker;
import com.icthh.xm.commons.cache.TenantCacheManager;
import com.icthh.xm.commons.cache.service.DynamicCaffeineCacheManager;
import com.icthh.xm.commons.cache.service.TenantAwareCacheManager;
import com.icthh.xm.commons.cache.service.XmCacheConfigurer;
import com.icthh.xm.commons.tenant.TenantContextHolder;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.CacheManager;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"application.tenant-memory-cache.enabled"}, havingValue="true")
public class XmTenantLepCacheConfig {
    public static final Integer CACHE_DEFAULTS = -1;

    @Bean
    @ConditionalOnMissingBean(value={Ticker.class})
    public Ticker ticker() {
        return Ticker.systemTicker();
    }

    @Bean
    public DynamicCaffeineCacheManager dynamicCaffeineCacheManager(Ticker ticker) {
        return new DynamicCaffeineCacheManager(ticker);
    }

    @Bean
    public XmCacheConfigurer xmCacheConfigurer(@Value(value="${spring.application.name}") String appName, ApplicationEventPublisher applicationEventPublisher) {
        return new XmCacheConfigurer(appName, applicationEventPublisher);
    }

    @Bean
    @Qualifier(value="lepCacheManager")
    public TenantCacheManager tenantAwareCacheManager(DynamicCaffeineCacheManager caffeineCacheManager, TenantContextHolder tenantContextHolder) {
        return new TenantAwareCacheManager((CacheManager)caffeineCacheManager, tenantContextHolder);
    }

    public static class XmCacheConfiguration {
        private String cacheName;
        private Integer initialCapacity = CACHE_DEFAULTS;
        private Integer maximumSize = CACHE_DEFAULTS;
        private Integer maximumWeight = CACHE_DEFAULTS;
        private Integer expireAfterWrite = CACHE_DEFAULTS;
        private Integer expireAfterAccess = CACHE_DEFAULTS;
        private boolean recordStats;

        public String getCacheName() {
            return this.cacheName;
        }

        public Integer getInitialCapacity() {
            return this.initialCapacity;
        }

        public Integer getMaximumSize() {
            return this.maximumSize;
        }

        public Integer getMaximumWeight() {
            return this.maximumWeight;
        }

        public Integer getExpireAfterWrite() {
            return this.expireAfterWrite;
        }

        public Integer getExpireAfterAccess() {
            return this.expireAfterAccess;
        }

        public boolean isRecordStats() {
            return this.recordStats;
        }

        public void setCacheName(String cacheName) {
            this.cacheName = cacheName;
        }

        public void setInitialCapacity(Integer initialCapacity) {
            this.initialCapacity = initialCapacity;
        }

        public void setMaximumSize(Integer maximumSize) {
            this.maximumSize = maximumSize;
        }

        public void setMaximumWeight(Integer maximumWeight) {
            this.maximumWeight = maximumWeight;
        }

        public void setExpireAfterWrite(Integer expireAfterWrite) {
            this.expireAfterWrite = expireAfterWrite;
        }

        public void setExpireAfterAccess(Integer expireAfterAccess) {
            this.expireAfterAccess = expireAfterAccess;
        }

        public void setRecordStats(boolean recordStats) {
            this.recordStats = recordStats;
        }
    }
}

