/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.store;

import com.icegreen.greenmail.foedus.util.MsgRangeFilter;
import com.icegreen.greenmail.imap.commands.IdRange;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.FolderListener;
import com.icegreen.greenmail.store.StoredMessage;
import com.icegreen.greenmail.store.StoredMessageCollection;
import jakarta.mail.Flags;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ListBasedStoredMessageCollection
implements StoredMessageCollection {
    private final List<StoredMessage> mailMessages = Collections.synchronizedList(new ArrayList());

    @Override
    public int size() {
        return this.mailMessages.size();
    }

    @Override
    public void add(StoredMessage storedMessage) {
        this.mailMessages.add(storedMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StoredMessage remove(long uid) {
        List<StoredMessage> list = this.mailMessages;
        synchronized (list) {
            for (int i = 0; i < this.mailMessages.size(); ++i) {
                StoredMessage message = this.mailMessages.get(i);
                if (message.getUid() != uid) continue;
                this.mailMessages.remove(i);
                return message;
            }
        }
        throw new IllegalArgumentException("No message for uid " + uid + " exists");
    }

    @Override
    public void clear() {
        this.mailMessages.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expungeMessage(int msn, Collection<FolderListener> mailboxListeners) {
        Collection<FolderListener> collection = mailboxListeners;
        synchronized (collection) {
            this.deleteMessage(msn);
            for (FolderListener expungeListener : mailboxListeners) {
                expungeListener.expunged(msn);
            }
        }
    }

    private void deleteMessage(int msn) {
        this.mailMessages.remove(msn - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFirstUnseen() {
        List<StoredMessage> list = this.mailMessages;
        synchronized (list) {
            for (int i = 0; i < this.mailMessages.size(); ++i) {
                StoredMessage message = this.mailMessages.get(i);
                if (message.isSet(Flags.Flag.SEEN)) continue;
                return i + 1;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMsn(long uid) throws FolderException {
        List<StoredMessage> list = this.mailMessages;
        synchronized (list) {
            for (int i = 0; i < this.mailMessages.size(); ++i) {
                StoredMessage message = this.mailMessages.get(i);
                if (message.getUid() != uid) continue;
                return i + 1;
            }
        }
        throw new FolderException("No such message of uid " + uid + ".");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<StoredMessage> getMessages(MsgRangeFilter range) {
        ArrayList<StoredMessage> ret = new ArrayList<StoredMessage>();
        List<StoredMessage> list = this.mailMessages;
        synchronized (list) {
            for (int i = 0; i < this.mailMessages.size(); ++i) {
                if (!range.includes(i + 1)) continue;
                ret.add(this.mailMessages.get(i));
            }
        }
        return ret;
    }

    @Override
    public List<StoredMessage> getMessages() {
        return Collections.unmodifiableList(this.mailMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] getMessageUids() {
        List<StoredMessage> list = this.mailMessages;
        synchronized (list) {
            long[] uids = new long[this.mailMessages.size()];
            for (int i = 0; i < this.mailMessages.size(); ++i) {
                StoredMessage message = this.mailMessages.get(i);
                uids[i] = message.getUid();
            }
            return uids;
        }
    }

    @Override
    public void expunge(List<FolderListener> folderListeners) {
        this.expunge(folderListeners, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void expunge(List<FolderListener> folderListeners, IdRange[] idRanges) {
        List<StoredMessage> list = this.mailMessages;
        synchronized (list) {
            for (int i = this.mailMessages.size() - 1; i >= 0; --i) {
                StoredMessage message = this.mailMessages.get(i);
                if (!message.isSet(Flags.Flag.DELETED) || idRanges != null && !IdRange.containsUid(idRanges, message.getUid())) continue;
                this.expungeMessage(i + 1, folderListeners);
            }
        }
    }

    @Override
    public StoredMessage get(int i) {
        return this.mailMessages.get(i);
    }

    @Override
    public Iterator<StoredMessage> iterator() {
        return this.mailMessages.iterator();
    }
}

