/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.authentication.AuthenticationData;
import com.ibm.ws.security.authentication.AuthenticationException;
import com.ibm.ws.security.authentication.AuthenticationService;
import com.ibm.ws.security.authentication.WSAuthenticationData;
import com.ibm.ws.security.registry.RegistryException;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.AuthenticationResult;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.util.Hashtable;
import java.util.Set;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WebProviderAuthenticatorHelper {
    private static final TraceComponent tc = Tr.register(WebProviderAuthenticatorHelper.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages");
    private final AtomicServiceReference<SecurityService> securityServiceRef;
    static final long serialVersionUID = -2515578849328032021L;

    public WebProviderAuthenticatorHelper(AtomicServiceReference<SecurityService> securityServiceRef) {
        this.securityServiceRef = securityServiceRef;
    }

    public AuthenticationResult loginWithUserName(HttpServletRequest req, HttpServletResponse res, String userName, Subject subj, Hashtable<String, Object> customProperties, boolean mapIdentityToRegistryUser) {
        Subject tempSubject = subj;
        if (tempSubject == null) {
            tempSubject = new Subject();
        }
        if (customProperties == null) {
            customProperties = new Hashtable();
        }
        SecurityService securityService = (SecurityService)this.securityServiceRef.getService();
        AuthenticationService authenticationService = securityService.getAuthenticationService();
        this.updateHashtable(userName, customProperties, mapIdentityToRegistryUser, authenticationService);
        tempSubject.getPrivateCredentials().add(customProperties);
        Subject subject = this.authenticateWithSubject(req, res, tempSubject);
        if (subject == null) {
            return new AuthenticationResult(AuthResult.FAILURE, "subject is null");
        }
        if (!mapIdentityToRegistryUser && !subject.isReadOnly()) {
            this.removeSecurityNameAndUniquedIdFromHashtable(subject, customProperties, mapIdentityToRegistryUser);
        }
        AuthenticationResult authResult = new AuthenticationResult(AuthResult.SUCCESS, subject);
        return authResult;
    }

    public AuthenticationResult loginWithHashtable(HttpServletRequest req, HttpServletResponse res, Subject partialSubject) {
        Subject subject = this.authenticateWithSubject(req, res, partialSubject);
        if (subject == null) {
            return new AuthenticationResult(AuthResult.FAILURE, "subject is null");
        }
        AuthenticationResult authResult = new AuthenticationResult(AuthResult.SUCCESS, subject);
        return authResult;
    }

    private void updateHashtable(String userName, Hashtable<String, Object> hashtable, boolean mapIdentityToRegistryUser, AuthenticationService authenticationService) {
        if (mapIdentityToRegistryUser) {
            this.addUserOnlyToHashTable(userName, hashtable, authenticationService);
        } else {
            hashtable.put("com.ibm.wsspi.security.cred.securityName", userName);
            if (hashtable.get("com.ibm.wsspi.security.cred.uniqueId") == null) {
                this.addUniqueIdToHashtable(hashtable, userName);
            }
        }
    }

    private void addUniqueIdToHashtable(Hashtable<String, Object> hashtable, String mapUserName) {
        String realm = "defaultRealm";
        try {
            realm = ((SecurityService)this.securityServiceRef.getService()).getUserRegistryService().getUserRegistry().getRealm();
        }
        catch (RegistryException registryException) {
            FFDCFilter.processException((Throwable)registryException, (String)"com.ibm.ws.webcontainer.security.WebProviderAuthenticatorHelper", (String)"125", (Object)this, (Object[])new Object[]{hashtable, mapUserName});
        }
        String uniqueID = new StringBuffer("user:").append(realm).append("/").append(mapUserName).toString();
        hashtable.put("com.ibm.wsspi.security.cred.uniqueId", uniqueID);
    }

    private void addUserOnlyToHashTable(String userName, Hashtable<String, Object> hashtable, AuthenticationService authenticationService) {
        if (!authenticationService.isAllowHashTableLoginWithIdOnly().booleanValue()) {
            hashtable.put("com.ibm.ws.authentication.internal.assertion", Boolean.TRUE);
        }
        hashtable.put("com.ibm.wsspi.security.cred.userId", userName);
    }

    private synchronized void removeSecurityNameAndUniquedIdFromHashtable(Subject subject, Hashtable<String, ?> props, boolean mapIdentityToRegistryUser) {
        Set<Object> privateCredentials = subject.getPrivateCredentials();
        if (privateCredentials.remove(props)) {
            props.remove("com.ibm.wsspi.security.cred.uniqueId");
            props.remove("com.ibm.wsspi.security.cred.securityName");
            if (!props.isEmpty()) {
                privateCredentials.add(props);
            }
        }
    }

    @FFDCIgnore(value={AuthenticationException.class})
    private Subject authenticateWithSubject(HttpServletRequest req, HttpServletResponse res, Subject subject) {
        Subject new_subject;
        block2: {
            new_subject = null;
            try {
                AuthenticationData authenticationData = this.createAuthenticationData(req, res);
                new_subject = ((SecurityService)this.securityServiceRef.getService()).getAuthenticationService().authenticate("system.WEB_INBOUND", authenticationData, subject);
            }
            catch (AuthenticationException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)"Exception when performing authenticateWithSubject.", (Object[])new Object[]{e});
            }
        }
        return new_subject;
    }

    @Trivial
    protected AuthenticationData createAuthenticationData(HttpServletRequest req, HttpServletResponse res) {
        WSAuthenticationData authenticationData = new WSAuthenticationData();
        authenticationData.set("HTTP_SERVLET_REQUEST", (Object)req);
        authenticationData.set("HTTP_SERVLET_RESPONSE", (Object)res);
        return authenticationData;
    }
}

