/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.servlet;

import com.ibm.ws.ffdc.FFDCFilter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

class CacheProxyReader
extends BufferedReader {
    boolean canMark = true;

    public CacheProxyReader(Reader in) {
        super(in);
    }

    public CacheProxyReader(Reader in, int sz) {
        super(in, sz);
        this.canMark = true;
        try {
            this.mark(sz);
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.cache.servlet.CacheProxyRequest.CacheProxyReader", (String)"496", (Object)this);
            throw new IllegalStateException("mark must succeed to init CacheProxyReader while computing cacheId: " + e.getMessage());
        }
        this.canMark = false;
    }

    protected void setCanMark(boolean b) {
        this.canMark = b;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        if (!this.canMark) {
            throw new IllegalStateException("CacheProxyReader does not support mark");
        }
        super.mark(readAheadLimit);
    }

    @Override
    public boolean markSupported() {
        return this.canMark;
    }

    @Override
    public void reset() throws IOException {
        if (!this.canMark) {
            throw new IllegalStateException("CacheProxyReader does not support mark/reset");
        }
        super.reset();
    }
}

