/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.webapp;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.servlet.error.ServletErrorReport;
import com.ibm.ws.webcontainer.exception.IncludeFileNotFoundException;
import com.ibm.ws.webcontainer.servlet.DefaultErrorReporter;
import com.ibm.wsspi.webcontainer.RequestProcessor;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.util.FFDCWrapper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.EmptyStackException;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;

public class WebAppErrorReport
extends ServletErrorReport {
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.webapp");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.webapp.WebAppErrorReport";
    private static final long serialVersionUID = 3257007635676148784L;

    public WebAppErrorReport() {
    }

    public WebAppErrorReport(String message) {
        super(message);
    }

    public WebAppErrorReport(String message, Throwable rootCause) {
        super(message, rootCause);
    }

    public WebAppErrorReport(Throwable rootCause) {
        super(rootCause);
    }

    @Override
    public void setErrorCode(int sc) {
        super.setErrorCode(sc);
    }

    @Override
    public void setTargetServletName(String servletName) {
        super.setTargetServletName(servletName);
    }

    public StackTraceElement[] getStackTrace() {
        Throwable th = this.getRootCause();
        if (th != null) {
            return th.getStackTrace();
        }
        return null;
    }

    public void printFullStackTrace(PrintWriter out) {
        WebAppErrorReport.printFullStackTrace(out, this);
    }

    public static void printFullStackTrace(PrintWriter out, ServletException e) {
        Throwable th;
        Stack<Throwable> errorStack = new Stack<Throwable>();
        errorStack.push(e);
        while (e != null) {
            th = e.getRootCause();
            e = th instanceof ServletException ? (ServletException)th : null;
            if (th == null) continue;
            errorStack.push(th);
        }
        try {
            while (true) {
                if ((th = (Throwable)errorStack.pop()) instanceof ServletErrorReport) {
                    th.printStackTrace(out);
                } else {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    th.printStackTrace(pw);
                    pw.flush();
                    out.print(DefaultErrorReporter.encodeChars(sw.toString()));
                }
                out.println("");
            }
        }
        catch (EmptyStackException ex) {
            FFDCWrapper.processException(ex, "com.ibm.ws.webcontainer.webapp.WebAppErrorReport.printFullStackTrace", "126");
            return;
        }
    }

    public static ServletErrorReport constructErrorReport(Throwable th, String path) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "constructErrorReport", "constructing error report for path -->" + path + " Throwable -->" + th);
        }
        WebAppErrorReport r = new WebAppErrorReport(th);
        r.setTargetServletName(path);
        Throwable rootCause = th;
        while (rootCause.getCause() != null) {
            rootCause = rootCause.getCause();
        }
        if (WCCustomProperties.SERVLET_30_FNF_BEHAVIOR && rootCause instanceof IncludeFileNotFoundException) {
            r.setErrorCode(500);
        } else if (rootCause instanceof FileNotFoundException) {
            r.setErrorCode(404);
        } else if (rootCause instanceof UnavailableException) {
            UnavailableException ue = (UnavailableException)rootCause;
            if (ue.isPermanent()) {
                r.setErrorCode(404);
            } else {
                r.setErrorCode(503);
            }
        } else if (rootCause instanceof IOException && th.getMessage() != null && th.getMessage().contains("CWWWC0005I")) {
            r.setErrorCode(400);
        } else {
            r.setErrorCode(500);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "constructErrorReport", "returning new servlet error report");
        }
        return r;
    }

    public static ServletErrorReport constructErrorReport(Throwable th, RequestProcessor requestProcessor) {
        WebAppErrorReport r = new WebAppErrorReport(th);
        if (requestProcessor != null && requestProcessor.getName() != null) {
            return WebAppErrorReport.constructErrorReport(th, requestProcessor.getName());
        }
        return WebAppErrorReport.constructErrorReport(th, "ServletNameNotFound");
    }
}

