/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.container.service.annocache;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.container.service.annocache.ModuleAnnotations;
import com.ibm.ws.container.service.annocache.WebAnnotations;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.kernel.security.thread.ThreadIdentityManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AnnotationsBetaHelper {
    private static final TraceComponent tc = Tr.register(AnnotationsBetaHelper.class, null, null);
    public static final boolean IS_LIBERTY_BETA_PRODUCT = true;
    public static final String OPEN_LIBERTY_PRODUCT_ID = "io.openliberty";
    public static final String OPEN_LIBERTY_CD_PRODUCT_ID = "com.ibm.websphere.appserver";
    public static final String EARLY_ACCESS = "EARLY_ACCESS";
    public static final String SOURCE_DEFAULTED = "defaulted";
    public static final String SOURCE_PROPERTY = "system property";
    public static final String ANNO_BETA_PROPERTY_NAME = "anno.beta";
    public static final Boolean ANNO_BETA_PROPERTY_VALUE = AnnotationsBetaHelper.getProperty("<static init>", "anno.beta");
    static final long serialVersionUID = 1052755769920091352L;

    public static boolean setIsLibertyBetaProduct() {
        String isBetaReason;
        boolean isBeta;
        Map allProductInfo;
        try {
            allProductInfo = ProductInfo.getAllProductInfo();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.container.service.annocache.AnnotationsBetaHelper", (String)"111", null, (Object[])new Object[0]);
            allProductInfo = null;
        }
        if (allProductInfo == null) {
            isBeta = false;
            isBetaReason = "Failed to read any product information";
        } else {
            ProductInfo productInfo = (ProductInfo)allProductInfo.get(OPEN_LIBERTY_CD_PRODUCT_ID);
            if (productInfo == null) {
                productInfo = (ProductInfo)allProductInfo.get(OPEN_LIBERTY_PRODUCT_ID);
            }
            if (productInfo == null) {
                isBeta = false;
                isBetaReason = "No product information (io.openliberty or com.ibm.websphere.appserver)";
            } else {
                String productEdition;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"<static init>", (Object[])new Object[]{"Using product information [ " + productInfo.getId() + " ]"});
                }
                if ((productEdition = productInfo.getEdition()) == null) {
                    isBeta = false;
                    isBetaReason = "No edition in product information (com.ibm.websphere.productEdition)";
                } else {
                    isBeta = productEdition.equals(EARLY_ACCESS);
                    isBetaReason = "Product edition (com.ibm.websphere.productEdition) is (" + productEdition + ")";
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"<static init>", (Object[])new Object[]{"Annotations beta enablement [ " + isBeta + " ]: " + isBetaReason});
        }
        return isBeta;
    }

    public static String getProperty(final String propertyName) {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            String string = AccessController.doPrivileged(new PrivilegedAction<String>(){
                static final long serialVersionUID = -2485913754468401403L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public String run() {
                    return System.getProperty(propertyName);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.container.service.annocache.AnnotationsBetaHelper$1", 1.class, null, null);
                }
            });
            return string;
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    @Trivial
    public static Boolean getProperty(String methodName, String propertyName) {
        String propertyText = AnnotationsBetaHelper.getProperty(propertyName);
        Boolean propertyValue = propertyText == null ? null : Boolean.valueOf(propertyText);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + ": Property [ " + propertyName + " ] [ " + propertyValue + " ]"), (Object[])new Object[0]);
        }
        return propertyValue;
    }

    @Trivial
    public static boolean getLibertyBeta() {
        if (ANNO_BETA_PROPERTY_VALUE != null) {
            return ANNO_BETA_PROPERTY_VALUE;
        }
        return true;
    }

    public static com.ibm.ws.container.service.annotations.ModuleAnnotations getModuleAnnotations(Container container) throws UnableToAdaptException {
        if (AnnotationsBetaHelper.getLibertyBeta()) {
            return (com.ibm.ws.container.service.annotations.ModuleAnnotations)container.adapt(ModuleAnnotations.class);
        }
        return (com.ibm.ws.container.service.annotations.ModuleAnnotations)container.adapt(com.ibm.ws.container.service.annotations.ModuleAnnotations.class);
    }

    public static com.ibm.ws.container.service.annotations.WebAnnotations getWebAnnotations(Container container) throws UnableToAdaptException {
        if (AnnotationsBetaHelper.getLibertyBeta()) {
            return (com.ibm.ws.container.service.annotations.WebAnnotations)container.adapt(WebAnnotations.class);
        }
        return (com.ibm.ws.container.service.annotations.WebAnnotations)container.adapt(com.ibm.ws.container.service.annotations.WebAnnotations.class);
    }
}

